
CREATE SEQUENCE IF NOT EXISTS target_item_seq START WITH 1 INCREMENT BY 1;

CREATE SEQUENCE IF NOT EXISTS target_order_item_seq START WITH 1 INCREMENT BY 1;

CREATE TABLE IF NOT EXISTS  district_portal_users
(
    district_id     BIGINT NOT NULL,
    portal_users_id BIGINT NOT NULL
);

CREATE TABLE IF NOT EXISTS portal_user_authorities
(
    portal_user_id BIGINT NOT NULL,
    authorities_id BIGINT NOT NULL,
    CONSTRAINT pk_portaluser_authorities PRIMARY KEY (portal_user_id, authorities_id)
);

CREATE TABLE IF NOT EXISTS  portal_user_district
(
    portal_user_id BIGINT NOT NULL,
    district_id    BIGINT NOT NULL
);

CREATE TABLE IF NOT EXISTS  portal_user_roles
(
    portal_user_id BIGINT NOT NULL,
    roles_id       BIGINT NOT NULL,
    CONSTRAINT pk_portaluser_roles PRIMARY KEY (portal_user_id, roles_id)
);

CREATE TABLE IF NOT EXISTS  target_item
(
    id        BIGINT NOT NULL,
    item_name VARCHAR(255),
    item_type VARCHAR(255),
    CONSTRAINT pk_targetitem PRIMARY KEY (id)
);

CREATE TABLE IF NOT EXISTS  target_order_item
(
    id       BIGINT NOT NULL,
    name     VARCHAR(255),
    quantity INTEGER,
    CONSTRAINT pk_targetorderitem PRIMARY KEY (id)
);

CREATE TABLE IF NOT EXISTS  target_order_target_order_items
(
    target_order_id       BIGINT NOT NULL,
    target_order_items_id BIGINT NOT NULL
);

ALTER TABLE user_role
    ADD authority VARCHAR(255);

ALTER TABLE portal_user_authorities
    ADD CONSTRAINT fk_poruseaut_on_portal_user FOREIGN KEY (portal_user_id) REFERENCES portal_user (id);

ALTER TABLE portal_user_authorities
    ADD CONSTRAINT fk_poruseaut_on_user_role FOREIGN KEY (authorities_id) REFERENCES user_role (id);

ALTER TABLE portal_user_roles
    ADD CONSTRAINT fk_poruserol_on_portal_user FOREIGN KEY (portal_user_id) REFERENCES portal_user (id);

ALTER TABLE portal_user_roles
    ADD CONSTRAINT fk_poruserol_on_user_role FOREIGN KEY (roles_id) REFERENCES user_role (id);

ALTER SEQUENCE back_pay_date_seq INCREMENT BY 1;

ALTER SEQUENCE back_pay_seq INCREMENT BY 1;

ALTER SEQUENCE bonus_date_seq INCREMENT BY 1;

ALTER SEQUENCE bonus_seq INCREMENT BY 1;

ALTER SEQUENCE hotel_seq INCREMENT BY 1;

ALTER SEQUENCE mileage_date_seq INCREMENT BY 1;

ALTER SEQUENCE mileage_seq INCREMENT BY 1;

ALTER SEQUENCE new_hire_seq INCREMENT BY 1;

ALTER SEQUENCE per_diem_seq INCREMENT BY 1;

ALTER SEQUENCE portal_user_seq INCREMENT BY 1;

ALTER SEQUENCE pto_seq INCREMENT BY 1;

ALTER SEQUENCE store_seq INCREMENT BY 1;

ALTER SEQUENCE target_order_seq INCREMENT BY 1;

ALTER SEQUENCE termination_seq INCREMENT BY 1;

ALTER SEQUENCE time_adjust_break_seq INCREMENT BY 1;

ALTER SEQUENCE time_adjustment_seq INCREMENT BY 1;

ALTER SEQUENCE uniform_seq INCREMENT BY 1;

ALTER SEQUENCE user_role_seq INCREMENT BY 1;

ALTER SEQUENCE work_ticket_seq INCREMENT BY 1;