/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.TimeAdjustBreak;
import com.cbmportal.portal.domains.TimeAdjustment;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.TimeAdjustmentRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.TimeAdjustmentService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class TimeAdjustmentServiceImpl
implements TimeAdjustmentService {
    private final Logger log = LoggerFactory.getLogger(TimeAdjustmentServiceImpl.class);
    private final TimeAdjustmentRepository timeAdjustmentRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public TimeAdjustmentServiceImpl(TimeAdjustmentRepository timeAdjustmentRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.timeAdjustmentRepository = timeAdjustmentRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processTimeAdjustment(TimeAdjustment timeAdjustment, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        StringBuilder breakInfo = new StringBuilder();
        File adjustInfo = new File(this.htmlFormLocation + "timeadjustment.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu hh:mm a");
        String fullEmployeeName = timeAdjustment.getEmployee().getEmployeeFirst() + " " + timeAdjustment.getEmployee().getEmployeeLast();
        String pdfFileName = "timeAdjustment-" + fullEmployeeName + "-" + timeAdjustment.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "timeAdjust/" + timeAdjustment.getEmployee().getEmployeeNumber() + "/";
        this.generateBreakInfo(breakInfo, timeAdjustment, dateFormatter, timeFormatter);
        Document doc = Jsoup.parse((File)adjustInfo, (String)"UTF-8", (String)"");
        this.log.info(doc.html());
        doc.getElementsByClass("breakInfo").html(breakInfo.toString());
        doc.getElementsByClass("employeeNum").html(timeAdjustment.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("reasonMissed").html(timeAdjustment.getReasonMissed());
        doc.getElementsByClass("employeeSig").html("<img src=" + timeAdjustment.getEmployeeSig() + " alt=\" This is employee signature\" />");
        doc.getElementsByClass("dmSig").html("<img src=" + timeAdjustment.getManagerSig() + " alt=\" This is manager signature\" />");
        doc.getElementsByClass("dm").html(timeAdjustment.getPortalUser().getUserFirst() + " " + timeAdjustment.getPortalUser().getUserLast());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Payroll.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, timeAdjustment.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                TimeAdjustment savedTimeAdjust = (TimeAdjustment)this.timeAdjustmentRepository.save(timeAdjustment);
                if (savedTimeAdjust.getId() != null) {
                    formResponse.setFormName("Time Adjustment Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/hr/timeAdjustmentSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("Time Adjustment Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    private void generateBreakInfo(StringBuilder breakInfo, TimeAdjustment timeAdjustment, DateTimeFormatter dateFormatter, DateTimeFormatter timeFormatter) {
        for (TimeAdjustBreak breaks : timeAdjustment.getBreaks()) {
            Long totalHours = Duration.between(breaks.getPunchIn(), breaks.getPunchOut()).toHours();
            Double adjustedHours = (double)totalHours.longValue() - breaks.getBreakAmount();
            breakInfo.append("<div class=adjust-date >").append(dateFormatter.format(breaks.getDate())).append("</div>");
            breakInfo.append("<div class=adjust-start-time>").append(timeFormatter.format(breaks.getPunchIn())).append("</div>");
            breakInfo.append("<div class=adjust-end-time>").append(timeFormatter.format(breaks.getPunchOut())).append("</div>");
            breakInfo.append("<div class=adjust-total-hrs>").append(totalHours).append(" hrs</div>");
            breakInfo.append("<div class=adjust-break-time>").append(breaks.getBreakAmount()).append(" hrs</div>");
            breakInfo.append("<div class=adjust-adjusted-hrs>").append(adjustedHours).append(" hrs</div>");
        }
    }
}

