/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.Mileage;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.MileageRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.MileageService;
import com.cbmportal.portal.services.PdfBuilderService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class MileageServiceImpl
implements MileageService {
    final Logger log = LoggerFactory.getLogger(MileageServiceImpl.class);
    private final MileageRepository mileageRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public MileageServiceImpl(MileageRepository mileageRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.mileageRepository = mileageRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processMileage(Mileage mileage, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File mileageHtml = new File(this.htmlFormLocation + "mileage.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = mileage.getEmployee().getEmployeeFirst() + " " + mileage.getEmployee().getEmployeeLast();
        String pdfFileName = "Mileage-" + fullEmployeeName + "-" + mileage.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "mileage/" + mileage.getEmployee().getEmployeeNumber() + "/";
        StringBuilder mileageInfo = new StringBuilder();
        this.mileageInject(mileage.getMileageDates(), dateFormatter, mileageInfo);
        Document doc = Jsoup.parse((File)mileageHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("mileageInfo").html(mileageInfo.toString());
        doc.getElementsByClass("comments").html(mileage.getComments());
        doc.getElementsByClass("employeeNum").html(mileage.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dm").html(mileage.getPortalUser().getUserFirst() + " " + mileage.getPortalUser().getUserLast());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Payroll.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, mileage.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                Mileage savedMileage = (Mileage)this.mileageRepository.save(mileage);
                if (savedMileage.getId() != null) {
                    formResponse.setFormName("Mileage Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/payroll/mileageSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.OK);
            formResponse.setFormName("Mileage Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    private void mileageInject(List<MileageDate> mileageDates, DateTimeFormatter dateTimeFormatter, StringBuilder mileageInfo) {
        for (MileageDate mileageItem : mileageDates) {
            mileageInfo.append("<div class=\"mileage-date\">").append(dateTimeFormatter.format(mileageItem.getDate())).append("</div>");
            mileageInfo.append("<div class=\"mileage-starting-location\">").append(mileageItem.getLocation1().getStoreNum()).append(" ").append(mileageItem.getLocation1().getName()).append("</div>");
            mileageInfo.append("<div class=\"mileage-ending-location\">").append(mileageItem.getLocation2().getStoreNum()).append(" ").append(mileageItem.getLocation2().getName()).append("</div>");
        }
    }
}

