/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.BonusDate;
import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.NewHire;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.WorkTicket;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import java.util.List;
import java.util.Objects;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Store {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="store_id_seq")
    @SequenceGenerator(name="store_id_seq", sequenceName="store_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    private String banner = null;
    @JsonProperty
    private String name = null;
    @JsonProperty
    @OneToOne
    private District district = null;
    @JsonProperty
    private String storeNum = null;
    @JsonProperty
    private String city;
    @JsonProperty
    private String state;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<WorkTicket> workTickets;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<TargetOrder> targetOrderList;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private NewHire newHire;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<BonusDate> bonuses;

    public Store() {
    }

    public Store(String city, String state) {
        this.city = city;
        this.state = state;
    }

    public Store(String banner, String name, District district, String storeNum, String city, String state) {
        this.banner = banner;
        this.name = name;
        this.district = district;
        this.city = city;
        this.state = state;
        this.storeNum = storeNum;
    }

    public String toString() {
        return "Store{id='" + this.id + "', banner='" + this.banner + "', name='" + this.name + "', district='" + String.valueOf(this.district) + "', storeNum='" + this.storeNum + "', city='" + this.city + "', state='" + this.state + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Store store = (Store)o;
        return Objects.equals(this.id, store.id) && Objects.equals(this.banner, store.banner) && Objects.equals(this.name, store.name) && Objects.equals(this.district, store.district) && Objects.equals(this.storeNum, store.storeNum) && Objects.equals(this.city, store.city) && Objects.equals(this.state, store.state);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.banner, this.name, this.district, this.storeNum, this.city, this.state);
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setBanner(String banner) {
        this.banner = banner;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public void setDistrict(District district) {
        this.district = district;
    }

    @JsonProperty
    public void setStoreNum(String storeNum) {
        this.storeNum = storeNum;
    }

    @JsonProperty
    public void setCity(String city) {
        this.city = city;
    }

    @JsonProperty
    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty
    public void setWorkTickets(List<WorkTicket> workTickets) {
        this.workTickets = workTickets;
    }

    @JsonProperty
    public void setTargetOrderList(List<TargetOrder> targetOrderList) {
        this.targetOrderList = targetOrderList;
    }

    @JsonProperty
    public void setNewHire(NewHire newHire) {
        this.newHire = newHire;
    }

    @JsonProperty
    public void setBonuses(List<BonusDate> bonuses) {
        this.bonuses = bonuses;
    }

    public Long getId() {
        return this.id;
    }

    public String getBanner() {
        return this.banner;
    }

    public String getName() {
        return this.name;
    }

    public District getDistrict() {
        return this.district;
    }

    public String getStoreNum() {
        return this.storeNum;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public List<WorkTicket> getWorkTickets() {
        return this.workTickets;
    }

    public List<TargetOrder> getTargetOrderList() {
        return this.targetOrderList;
    }

    public NewHire getNewHire() {
        return this.newHire;
    }

    public List<BonusDate> getBonuses() {
        return this.bonuses;
    }
}

