/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class PerDiem {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="perDiem_id_seq")
    @SequenceGenerator(name="perDiem_id_seq", sequenceName="per_diem_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToOne
    private Store store;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<MileageDate> mileageDates;
    @JsonProperty
    private LocalDate firstHotelNight;
    @JsonProperty
    private LocalDate lastHotelNight;
    @JsonProperty
    private LocalDate arrivalDate;
    @JsonProperty
    private LocalDate departureDate;
    @JsonProperty
    private String reasonPayMissed;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    private PortalUser portalUser;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public PerDiem() {
    }

    public PerDiem(Store store, List<MileageDate> mileageDates, LocalDate firstHotelNight, LocalDate lastHotelNight, LocalDate arrivalDate, LocalDate departureDate, String reasonPayMissed, Employee employee, PortalUser portalUser, ApiError apiError) {
        this.store = store;
        this.mileageDates = mileageDates;
        this.firstHotelNight = firstHotelNight;
        this.lastHotelNight = lastHotelNight;
        this.arrivalDate = arrivalDate;
        this.departureDate = departureDate;
        this.reasonPayMissed = reasonPayMissed;
        this.employee = employee;
        this.portalUser = portalUser;
        this.apiError = apiError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerDiem perDiem = (PerDiem)o;
        return Objects.equals(this.id, perDiem.id) && Objects.equals(this.store, perDiem.store) && Objects.equals(this.mileageDates, perDiem.mileageDates) && Objects.equals(this.firstHotelNight, perDiem.firstHotelNight) && Objects.equals(this.lastHotelNight, perDiem.lastHotelNight) && Objects.equals(this.arrivalDate, perDiem.arrivalDate) && Objects.equals(this.departureDate, perDiem.departureDate) && Objects.equals(this.reasonPayMissed, perDiem.reasonPayMissed) && Objects.equals(this.employee, perDiem.employee) && Objects.equals(this.portalUser, perDiem.portalUser) && Objects.equals(this.apiError, perDiem.apiError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.store, this.mileageDates, this.firstHotelNight, this.lastHotelNight, this.arrivalDate, this.departureDate, this.reasonPayMissed, this.employee, this.portalUser, this.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", PerDiem.class.getSimpleName() + "[", "]").add("id=" + this.id).add("store=" + String.valueOf(this.store)).add("mileageDates=" + String.valueOf(this.mileageDates)).add("firstHotelNight=" + String.valueOf(this.firstHotelNight)).add("lastHotelNight=" + String.valueOf(this.lastHotelNight)).add("arrivalDate=" + String.valueOf(this.arrivalDate)).add("departureDate=" + String.valueOf(this.departureDate)).add("reasonPayMissed='" + this.reasonPayMissed + "'").add("employee=" + String.valueOf(this.employee)).add("portalUser=" + String.valueOf(this.portalUser)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    public void setMileageDates(List<MileageDate> mileageDates) {
        this.mileageDates = mileageDates;
    }

    @JsonProperty
    public void setFirstHotelNight(LocalDate firstHotelNight) {
        this.firstHotelNight = firstHotelNight;
    }

    @JsonProperty
    public void setLastHotelNight(LocalDate lastHotelNight) {
        this.lastHotelNight = lastHotelNight;
    }

    @JsonProperty
    public void setArrivalDate(LocalDate arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    @JsonProperty
    public void setDepartureDate(LocalDate departureDate) {
        this.departureDate = departureDate;
    }

    @JsonProperty
    public void setReasonPayMissed(String reasonPayMissed) {
        this.reasonPayMissed = reasonPayMissed;
    }

    @JsonProperty
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public Store getStore() {
        return this.store;
    }

    public List<MileageDate> getMileageDates() {
        return this.mileageDates;
    }

    public LocalDate getFirstHotelNight() {
        return this.firstHotelNight;
    }

    public LocalDate getLastHotelNight() {
        return this.lastHotelNight;
    }

    public LocalDate getArrivalDate() {
        return this.arrivalDate;
    }

    public LocalDate getDepartureDate() {
        return this.departureDate;
    }

    public String getReasonPayMissed() {
        return this.reasonPayMissed;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

