/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Address;
import com.cbmportal.portal.domains.Gender;
import com.cbmportal.portal.domains.WorkTicket;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Employee {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="emp_id_seq")
    @SequenceGenerator(name="emp_id_seq", sequenceName="employee_seq", allocationSize=1)
    private Long id;
    private String employeeFirst = null;
    private String employeeMiddle = null;
    private String employeeLast = null;
    private String employeeSecondLast = null;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Address address;
    private Integer employeeNumber = null;
    private String phone1;
    private String phone2;
    private String ssn;
    private LocalDate dob;
    private Gender gender;
    private String email;
    @JsonProperty
    @OneToMany
    private List<WorkTicket> workTickets;

    public Employee() {
    }

    public Employee(String employeeFirst, String employeeMiddle, String employeeLast, String employeeSecondLast, Address address, Integer employeeNumber, String phone1, String phone2, String ssn, LocalDate dob, Gender gender, String email) {
        this.employeeFirst = employeeFirst;
        this.employeeMiddle = employeeMiddle;
        this.employeeLast = employeeLast;
        this.employeeSecondLast = employeeSecondLast;
        this.address = address;
        this.employeeNumber = employeeNumber;
        this.phone1 = phone1;
        this.phone2 = phone2;
        this.ssn = ssn;
        this.dob = dob;
        this.gender = gender;
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employee employee = (Employee)o;
        return Objects.equals(this.id, employee.id) && Objects.equals(this.employeeFirst, employee.employeeFirst) && Objects.equals(this.employeeMiddle, employee.employeeMiddle) && Objects.equals(this.employeeLast, employee.employeeLast) && Objects.equals(this.employeeSecondLast, employee.employeeSecondLast) && Objects.equals(this.address, employee.address) && Objects.equals(this.employeeNumber, employee.employeeNumber) && Objects.equals(this.phone1, employee.phone1) && Objects.equals(this.phone2, employee.phone2) && Objects.equals(this.ssn, employee.ssn) && Objects.equals(this.dob, employee.dob) && this.gender == employee.gender && Objects.equals(this.email, employee.email);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.employeeFirst, this.employeeMiddle, this.employeeLast, this.employeeSecondLast, this.address, this.employeeNumber, this.phone1, this.phone2, this.ssn, this.dob, this.gender, this.email});
    }

    public String toString() {
        return new StringJoiner(", ", Employee.class.getSimpleName() + "[", "]").add("id=" + this.id).add("employeeFirst='" + this.employeeFirst + "'").add("employeeMiddle='" + this.employeeMiddle + "'").add("employeeLast='" + this.employeeLast + "'").add("employeeSecondLast='" + this.employeeSecondLast + "'").add("address=" + String.valueOf(this.address)).add("employeeNumber=" + this.employeeNumber).add("phone1='" + this.phone1 + "'").add("phone2='" + this.phone2 + "'").add("ssn='" + this.ssn + "'").add("dob=" + String.valueOf(this.dob)).add("gender=" + String.valueOf((Object)this.gender)).add("email='" + this.email + "'").toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEmployeeFirst(String employeeFirst) {
        this.employeeFirst = employeeFirst;
    }

    public void setEmployeeMiddle(String employeeMiddle) {
        this.employeeMiddle = employeeMiddle;
    }

    public void setEmployeeLast(String employeeLast) {
        this.employeeLast = employeeLast;
    }

    public void setEmployeeSecondLast(String employeeSecondLast) {
        this.employeeSecondLast = employeeSecondLast;
    }

    @JsonProperty
    public void setAddress(Address address) {
        this.address = address;
    }

    public void setEmployeeNumber(Integer employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public void setPhone1(String phone1) {
        this.phone1 = phone1;
    }

    public void setPhone2(String phone2) {
        this.phone2 = phone2;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public void setDob(LocalDate dob) {
        this.dob = dob;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty
    public void setWorkTickets(List<WorkTicket> workTickets) {
        this.workTickets = workTickets;
    }

    public Long getId() {
        return this.id;
    }

    public String getEmployeeFirst() {
        return this.employeeFirst;
    }

    public String getEmployeeMiddle() {
        return this.employeeMiddle;
    }

    public String getEmployeeLast() {
        return this.employeeLast;
    }

    public String getEmployeeSecondLast() {
        return this.employeeSecondLast;
    }

    public Address getAddress() {
        return this.address;
    }

    public Integer getEmployeeNumber() {
        return this.employeeNumber;
    }

    public String getPhone1() {
        return this.phone1;
    }

    public String getPhone2() {
        return this.phone2;
    }

    public String getSsn() {
        return this.ssn;
    }

    public LocalDate getDob() {
        return this.dob;
    }

    public Gender getGender() {
        return this.gender;
    }

    public String getEmail() {
        return this.email;
    }

    public List<WorkTicket> getWorkTickets() {
        return this.workTickets;
    }
}

