/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.NewHire;
import com.cbmportal.portal.domains.Termination;
import com.cbmportal.portal.domains.Uniform;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.services.NewHireService;
import com.cbmportal.portal.services.TerminationService;
import com.cbmportal.portal.services.UniformService;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import org.jsoup.helper.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v1/hr/"})
public class HrSubmissions {
    private final Logger log = LoggerFactory.getLogger(HrSubmissions.class);
    private final TerminationService terminationService;
    private final UniformService uniformService;
    private final NewHireService newHireService;

    public HrSubmissions(TerminationService terminationService, UniformService uniformService, NewHireService newHireService) {
        this.terminationService = terminationService;
        this.uniformService = uniformService;
        this.newHireService = newHireService;
    }

    @PostMapping(value={"terminationSubmit"})
    ResponseEntity<FormSubmissionResponse> termSubmit(@RequestBody Termination termination, HttpServletResponse response) throws IOException {
        this.log.info(termination.toString());
        if (termination.getEligibleRehire() != null && termination.getTermType() != null && termination.getPortalUser() != null && termination.getQuitReason() != null && termination.getLastDayWorked() != null && termination.getTwoWeeksGiven() != null && termination.getWarningsGiven() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.terminationService.processTermination(termination, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitTermination", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Termination Form", false, new ApiError("submitTermination", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"uniformSubmit"})
    ResponseEntity<FormSubmissionResponse> uniformSubmit(@RequestBody Uniform uniform, HttpServletResponse response) throws IOException {
        this.log.info(uniform.toString());
        if (uniform.getEmployee().getEmployeeNumber() != null && uniform.getEmployee().getEmployeeFirst() != null && uniform.getEmployee().getEmployeeLast() != null && uniform.getSize() != null && uniform.getQuantity() != null && uniform.getTotal() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.uniformService.processUniform(uniform, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitUniform", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Uniform Form", false, new ApiError("submitUniform", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"newHireSubmit"}, consumes={"multipart/form-data"})
    ResponseEntity<FormSubmissionResponse> newHireSubmit(@RequestPart(value="newHireInfoJSON") String newHireInfo, @RequestPart(value="idBadge") MultipartFile idBadge, @RequestPart(value="govIdFront") MultipartFile govIdFront, @RequestPart(value="govIdRear") MultipartFile govIdBack, @RequestPart(value="ssnCard") MultipartFile ssnCard, HttpServletResponse response) throws IOException {
        this.log.info(newHireInfo);
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        NewHire newHire = (NewHire)mapper.readValue(newHireInfo, NewHire.class);
        this.log.info(newHire.toString());
        if (newHire.getEmployee().getEmployeeFirst() != null && newHire.getEmployee().getEmployeeLast() != null && newHire.getHireType() != null && newHire.getStore() != null && newHire.getDocumentNumber() != null && newHire.getDocumentTitle() != null && newHire.getDocumentExp() != null && newHire.getEmployee().getAddress().getAddress1() != null && newHire.getEmployee().getAddress().getCity() != null && newHire.getEmployee().getAddress().getState() != null && newHire.getEmployee().getAddress().getZip() != null && newHire.getFirstDayWorked() != null && newHire.getNumOfHours() != null && newHire.getNumWorkDays() != null && newHire.getPayRate() != null && newHire.getPosition() != null && newHire.getPositionNum() != null && newHire.getPreferredLanguage() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.newHireService.processNewHire(newHire, idBadge, govIdFront, govIdBack, ssnCard, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitNewHire", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("NewHire Form", false, new ApiError("submitNewHire", "Please fill in every field that has an * next to it.")));
    }
}

