/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.repositories.WorkTicketRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.WorkTicketService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class WorkTicketServiceImpl
implements WorkTicketService {
    final Logger log = LoggerFactory.getLogger(WorkTicketServiceImpl.class);
    private final WorkTicketRepository workTicketRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public WorkTicketServiceImpl(WorkTicketRepository workTicketRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.workTicketRepository = workTicketRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processWorkTicket(WorkTicket wt, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File wtHtml = new File(this.htmlFormLocation + "workticket.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = wt.getEmployee().getEmployeeFirst() + " " + wt.getEmployee().getEmployeeLast();
        String pdfFileName = "wt-" + wt.getEmployee().getEmployeeNumber() + "-" + LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "wt/" + wt.getEmployee().getEmployeeNumber() + "/";
        Document doc = Jsoup.parse((File)wtHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("currentLocation").html(wt.getCurrentLocation().getStoreNum() + " " + wt.getCurrentLocation().getName());
        doc.getElementsByClass("city").html(wt.getCurrentLocation().getCity());
        doc.getElementsByClass("state").html(wt.getCurrentLocation().getState());
        doc.getElementsByClass("projectStoreName").html(wt.getProjectLocation().getStoreNum() + " " + wt.getProjectLocation().getName());
        doc.getElementsByClass("projectStoreCity").html(wt.getProjectLocation().getCity());
        doc.getElementsByClass("projectStoreState").html(wt.getProjectLocation().getState());
        doc.getElementsByClass("typeOfWork").html(wt.getTypeOfWork().getTypeOfWork());
        doc.getElementsByClass("employeeNum").html(wt.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("notes").html(wt.getNotes());
        doc.getElementsByClass("equipmentNeeded").html(wt.getEquipmentNeeded());
        doc.getElementsByClass("isBillable").html(wt.getIsBillable());
        doc.getElementsByClass("orderSubmitted").html(wt.getSupplyOrderSubmitted() != false ? "Yes" : "No");
        doc.getElementsByClass("orderNumber").html(wt.getOrderNumber());
        doc.getElementsByClass("supplyOrderDate").html(dateFormatter.format(wt.getSupplyOrderDate()));
        doc.getElementsByClass("projectStartDate").html(dateFormatter.format(wt.getProjectStartDate()));
        doc.getElementsByClass("projectEndDate").html(dateFormatter.format(wt.getProjectEndDate()));
        doc.getElementsByClass("dm").html(wt.getPortalUser().getUserFirst() + " " + wt.getPortalUser().getUserLast());
        this.log.info(doc.html());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Finance.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, wt.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                WorkTicket savedWT = (WorkTicket)this.workTicketRepository.save(wt);
                if (savedWT.getId() != null) {
                    formResponse.setFormName("Work Ticket");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/finance/workTicketSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setApiError(error);
            formResponse.setFormName("Work Ticket");
            formResponse.setSuccess(false);
        }
        return formResponse;
    }
}

