/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.services.TokenService;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.stereotype.Service;

@Service
public class TokenServiceImpl
implements TokenService {
    private final JwtEncoder jwtEncoder;
    private final String auth_secret;

    public TokenServiceImpl(JwtEncoder jwtEncoder, @Value(value="${cbm.signSecret") String authSecret) {
        this.jwtEncoder = jwtEncoder;
        this.auth_secret = authSecret;
    }

    @Override
    public String generateJwt(@NotNull Authentication auth) {
        Instant expire = Instant.now().plusSeconds(7200L);
        String scope = auth.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(" "));
        JwtClaimsSet claims = JwtClaimsSet.builder().issuer("cbmPortal").issuedAt(Instant.now()).expiresAt(expire).subject(auth.getName()).claim("roles", (Object)scope).build();
        return this.jwtEncoder.encode(JwtEncoderParameters.from((JwtClaimsSet)claims)).getTokenValue();
    }
}

