/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.Termination;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.TerminationRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.TerminationService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class TerminationServiceImpl
implements TerminationService {
    private final Logger log = LoggerFactory.getLogger(TerminationServiceImpl.class);
    private final TerminationRepository terminationRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public TerminationServiceImpl(TerminationRepository terminationRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.terminationRepository = terminationRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processTermination(Termination termination, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File terminationHtml = new File(this.htmlFormLocation + "termination.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = termination.getEmployee().getEmployeeFirst() + " " + termination.getEmployee().getEmployeeLast();
        String pdfFileName = "termination-" + fullEmployeeName + "-" + termination.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "termination/" + termination.getEmployee().getEmployeeNumber() + "/";
        Document doc = Jsoup.parse((File)terminationHtml, (String)"UTF-8", (String)"");
        TerminationServiceImpl.wereWarningsGiven(termination, doc);
        TerminationServiceImpl.wasTwoWeeksGiven(termination, doc);
        TerminationServiceImpl.isEligibleForRehire(termination, doc);
        doc.getElementsByClass("employeeNum").html(termination.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeFirstName").html(termination.getEmployee().getEmployeeFirst());
        doc.getElementsByClass("employeeLastName").html(termination.getEmployee().getEmployeeLast());
        doc.getElementsByClass("employeeSecondLastName").html(termination.getEmployee().getEmployeeSecondLast());
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("lastDayWorked").html(dateFormatter.format(termination.getLastDayWorked()));
        doc.getElementsByClass("termType").html(termination.getTermType().getTermType());
        TerminationServiceImpl.didNoShowFirstDay(termination, doc);
        doc.getElementsByClass("dm").html(termination.getPortalUser().getUserFirst() + " " + termination.getPortalUser().getUserLast());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Terminations.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, termination.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                Termination savedTerm = (Termination)this.terminationRepository.save(termination);
                if (savedTerm.getId() != null) {
                    formResponse.setFormName("Termination Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/hr/termSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("Termination Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    private static void didNoShowFirstDay(Termination termination, Document doc) {
        if (!Objects.equals(termination.getTermType().toString(), "noShowFirstDay")) {
            doc.getElementsByClass("quitReason").html("<td>Reason employee quit: " + termination.getQuitReason() + "</td>");
        } else {
            doc.getElementsByClass("quitReason").html("<td>Reason employee quit: N/A</td>");
        }
    }

    private static void wereWarningsGiven(Termination termination, Document doc) {
        if (Objects.equals(termination.getTermType().toString(), "Other")) {
            if (termination.getWarningsGiven().booleanValue()) {
                doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">Yes</span> ");
            } else {
                doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">No</span> ");
            }
        } else {
            doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">N/A</span> ");
        }
    }

    private static void wasTwoWeeksGiven(Termination termination, Document doc) {
        if (Objects.equals(termination.getTermType().toString(), "twoWeeks")) {
            if (termination.getTwoWeeksGiven().booleanValue()) {
                doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">Yes</span> </td>");
            } else {
                doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">No</span> </td>");
            }
        } else {
            doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">N/A</span> </td>");
        }
    }

    private static void isEligibleForRehire(Termination termination, Document doc) {
        if (termination.getEligibleRehire().booleanValue()) {
            doc.getElementsByClass("eligibleRehire").html("Eligible for rehire: Yes");
        } else {
            doc.getElementsByClass("eligibleRehire").html("Eligible for rehire: No");
        }
    }
}

