/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.TargetOrderItem;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.TargetOrderRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.TargetOrderService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class TargetOrderServiceImpl
implements TargetOrderService {
    final Logger log = LoggerFactory.getLogger(TargetOrderServiceImpl.class);
    private final TargetOrderRepository targetOrderRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public TargetOrderServiceImpl(TargetOrderRepository targetOrderRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.targetOrderRepository = targetOrderRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processTargetOrder(TargetOrder targetOrder, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File targetOrderHtml = new File(this.htmlFormLocation + "targetorder.html");
        StringBuilder targetOrderList = new StringBuilder();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = targetOrder.getPortalUser().getUserFirst() + " " + targetOrder.getPortalUser().getUserLast();
        String pdfFileName = "targetOrder-" + targetOrder.getStore().getStoreNum() + "-" + targetOrder.getStore().getName() + "- Monthly Supply Order-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "targetOrder/" + targetOrder.getPortalUser().getUsername() + "/";
        this.formatItemList(targetOrder.getTargetOrderItems(), targetOrderList);
        Document doc = Jsoup.parse((File)targetOrderHtml, (String)"UTF-8", (String)"");
        this.log.info(doc.toString());
        doc.getElementsByClass("items").html(targetOrderList.toString());
        doc.getElementsByClass("store").html(targetOrder.getStore().getStoreNum() + " " + targetOrder.getStore().getName());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("comments").html(targetOrder.getComments());
        this.log.info(doc.html());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Supply.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, targetOrder.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                TargetOrder savedOrder = (TargetOrder)this.targetOrderRepository.save(targetOrder);
                if (savedOrder.getId() != null) {
                    formResponse.setFormName("Target Order");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/ops/targetOrderSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("Target Order");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    void formatItemList(List<TargetOrderItem> targetOrderItems, StringBuilder targetOrderList) {
        for (TargetOrderItem targetOrderItem : targetOrderItems) {
            targetOrderList.append("<div class=\"item-name\"><p>").append(targetOrderItem.getName()).append("</p></div>");
            targetOrderList.append("<div class=\"item-quantity\"><p>").append(targetOrderItem.getQuantity()).append("</p></div>");
        }
    }
}

