/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.Pto;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.PtoRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.PtoService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class PtoServiceImpl
implements PtoService {
    final Logger log = LoggerFactory.getLogger(PtoServiceImpl.class);
    private final PtoRepository ptoRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public PtoServiceImpl(PtoRepository ptoRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.ptoRepository = ptoRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processPto(Pto pto, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File ptoHtml = new File(this.htmlFormLocation + "pto.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = pto.getEmployee().getEmployeeFirst() + "-" + pto.getEmployee().getEmployeeLast();
        String pdfFileName = "pto-" + fullEmployeeName + "-" + pto.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "pto/" + pto.getEmployee().getEmployeeNumber() + "/";
        Document doc = Jsoup.parse((File)ptoHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("absenceFrom").html(dateFormatter.format(pto.getAbsenceFrom()));
        doc.getElementsByClass("absenceTo").html(dateFormatter.format(pto.getAbsenceTo()));
        doc.getElementsByClass("service").html(pto.getDepartment().getDepartment());
        doc.getElementsByClass("employeeNum").html(pto.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("hours").html(pto.getHours().toString());
        doc.getElementsByClass("comments").html(pto.getComments());
        doc.getElementsByClass("dmSig").html("<img src=" + pto.getSig() + " alt=\" This is signature\" />");
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dm").html(pto.getPortalUser().getUserFirst() + " " + pto.getPortalUser().getUserLast());
        this.log.info("Before output stream");
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Payroll.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, pto.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                Pto savedPto = (Pto)this.ptoRepository.save(pto);
                if (savedPto.getId() != null) {
                    formResponse.setFormName("PTO Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/payroll/ptoSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("PTO Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    @Override
    public Pto processPto(Pto pto) throws IOException {
        return null;
    }
}

