/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.UserPermission;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.PortalUserSafeVO;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.services.PortalUserService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PortalUserServiceImpl
implements UserDetailsService,
PortalUserService {
    final Logger log = LoggerFactory.getLogger(PortalUserServiceImpl.class);
    private final PortalUserRepository portalUserRepository;
    private final PasswordEncoder encoder;

    public PortalUserServiceImpl(PortalUserRepository portalUserRepository, PasswordEncoder encoder) {
        this.portalUserRepository = portalUserRepository;
        this.encoder = encoder;
    }

    @Override
    public PortalUser createPortalUser(PortalUser portalUser, HttpServletResponse response) {
        try {
            portalUser.setPermission(this.permissionCheck(portalUser.getPermission().toString()));
            response.setStatus(HttpStatus.OK.value());
            return (PortalUser)this.portalUserRepository.save(portalUser);
        }
        catch (DataAccessException dExc) {
            PortalUser portalUser1 = new PortalUser();
            this.log.error(dExc.getMessage());
            ApiError error = new ApiError("/admin/createPortalUser", dExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            portalUser1.setApiError(error);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return portalUser1;
        }
    }

    private UserPermission permissionCheck(String permission) {
        if (Objects.equals(permission, UserPermission.Admin.toString())) {
            return UserPermission.Admin;
        }
        if (Objects.equals(permission, UserPermission.Office.toString())) {
            return UserPermission.Office;
        }
        if (Objects.equals(permission, UserPermission.DM.toString())) {
            return UserPermission.DM;
        }
        return UserPermission.PS;
    }

    @Override
    public PortalUser getDm(String userName) {
        return this.portalUserRepository.findPortalUserByUserName(userName).orElse(new PortalUser());
    }

    @Override
    public PortalUserSafeVO updatePortalUser(PortalUser portalUser) {
        PortalUser updatedUser = (PortalUser)this.portalUserRepository.save(portalUser);
        PortalUserSafeVO portalUserSafeVO = new PortalUserSafeVO();
        portalUserSafeVO.setUserFirst(updatedUser.getUserFirst());
        portalUserSafeVO.setUserLast(updatedUser.getUserLast());
        portalUserSafeVO.setId(updatedUser.getId());
        portalUserSafeVO.setEmail(updatedUser.getEmail());
        portalUserSafeVO.setUserName(updatedUser.getUsername());
        return portalUserSafeVO;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.portalUserRepository.findPortalUserByUserName(username).orElseThrow(() -> new UsernameNotFoundException("Your username/password was not found."));
    }
}

