/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.NonMnMileage;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.NonMnMileageRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.NonMnMileageService;
import com.cbmportal.portal.services.PdfBuilderService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class NonMnMileageServiceImpl
implements NonMnMileageService {
    final Logger log = LoggerFactory.getLogger(NonMnMileageServiceImpl.class);
    private final NonMnMileageRepository nonMnMileageRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public NonMnMileageServiceImpl(NonMnMileageRepository nonMnMileageRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.nonMnMileageRepository = nonMnMileageRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processMileage(NonMnMileage nonMnMileage, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File mileageHtml = new File(this.htmlFormLocation + "nonmnmileage.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = nonMnMileage.getEmployee().getEmployeeFirst() + " " + nonMnMileage.getEmployee().getEmployeeLast();
        String pdfFileName = "Non-MN-Mileage-" + fullEmployeeName + "-" + nonMnMileage.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "nonMnMileage/" + nonMnMileage.getEmployee().getEmployeeNumber() + "/";
        StringBuilder nonMnMileageInfo = new StringBuilder();
        this.mileageInject(nonMnMileage.getMileageDates(), dateFormatter, nonMnMileageInfo);
        Document doc = Jsoup.parse((File)mileageHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("mileageInfo").html(nonMnMileageInfo.toString());
        doc.getElementsByClass("comments").html(nonMnMileage.getComments());
        doc.getElementsByClass("employeeNum").html(nonMnMileage.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dm").html(nonMnMileage.getPortalUser().getUserFirst() + " " + nonMnMileage.getPortalUser().getUserLast());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Finance.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, nonMnMileage.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                NonMnMileage savedMileage = (NonMnMileage)this.nonMnMileageRepository.save(nonMnMileage);
                if (savedMileage.getId() != null) {
                    formResponse.setFormName("Non MN Mileage Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/finance/mileageSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.OK);
            formResponse.setFormName("Mileage Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    private void mileageInject(List<MileageDate> mileageDates, DateTimeFormatter dateTimeFormatter, StringBuilder mileageInfo) {
        for (MileageDate mileageItem : mileageDates) {
            mileageInfo.append("<div class=\"mileage-date\">").append(dateTimeFormatter.format(mileageItem.getDate())).append("</div>");
            mileageInfo.append("<div class=\"mileage-starting-location\">").append(mileageItem.getLocation1().getStoreNum()).append(" ").append(mileageItem.getLocation1().getName()).append("</div>");
            mileageInfo.append("<div class=\"mileage-ending-location\">").append(mileageItem.getLocation2().getStoreNum()).append(" ").append(mileageItem.getLocation2().getName()).append("</div>");
            mileageInfo.append("<div class=\"rt-ow-info\">").append((Object)mileageItem.getRt_ow()).append("</div>");
        }
    }
}

