/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.HotelRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.HotelService;
import com.cbmportal.portal.services.PdfBuilderService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class HotelServiceImpl
implements HotelService {
    final Logger log = LoggerFactory.getLogger(HotelServiceImpl.class);
    private final HotelRepository hotelRepository;
    private final PdfBuilderService pdfBuilderService;
    private final EmailService emailService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public HotelServiceImpl(HotelRepository hotelRepository, PdfBuilderService pdfBuilderService, EmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.hotelRepository = hotelRepository;
        this.pdfBuilderService = pdfBuilderService;
        this.emailService = emailService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse requestHotel(Hotel hotel, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File hotelHtml = new File(this.htmlFormLocation + "hotel.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String pdfFileName = "Hotel-" + hotel.getStore().getStoreNum() + "-" + hotel.getStore().getName() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "hotel/" + hotel.getPortalUser().getUsername() + "/";
        Document doc = Jsoup.parse((File)hotelHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("location").html(hotel.getStore().getStoreNum() + " " + hotel.getStore().getName());
        doc.getElementsByClass("numOfRooms").html(hotel.getNumOfRooms().toString());
        doc.getElementsByClass("numOfBeds").html(hotel.getNumOfBeds().toString());
        doc.getElementsByClass("psInfo").html(this.generatePSInfo(hotel, this.log));
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("checkIn").html(dateFormatter.format(hotel.getCheckIn()));
        doc.getElementsByClass("checkOut").html(dateFormatter.format(hotel.getCheckOut()));
        doc.getElementsByClass("hotelReason").html(hotel.getHotelReason().getHotelReason());
        doc.getElementsByClass("workTicketNum").html(hotel.getWorkTicket());
        doc.getElementsByClass("notes").html(hotel.getComments());
        doc.getElementsByClass("dm").html(hotel.getPortalUser().getUserFirst() + " " + hotel.getPortalUser().getUserLast());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Finance.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, hotel.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                Hotel savedHotel = (Hotel)this.hotelRepository.save(hotel);
                if (savedHotel.getId() != null) {
                    formResponse.setFormName("Hotel Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/finance/hotelSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("Hotel Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    String generatePSInfo(Hotel hotel, Logger log) {
        StringBuilder ps = new StringBuilder();
        if (!hotel.getNewPS().isEmpty()) {
            ps.append("<div class=\"newps-title\">New Employee Name</div>");
            ps.append("<div class=\"newps-info\">").append(hotel.getNewPS()).append("</div>");
        } else {
            ps.append("<div class=\"ps1-title\" >Employee 1</div>");
            ps.append("<div class=\"ps1-info\">").append(hotel.getPs1().getFirstName()).append(" ").append(hotel.getPs1().getLastName()).append("</div>");
            ps.append("<div class=\"ps2-title\">Employee 2</div>");
            ps.append("<div class=\"ps2-info\">").append(hotel.getPs2().getFirstName()).append(" ").append(hotel.getPs2().getLastName()).append("</div>");
        }
        log.info(ps.toString());
        return ps.toString();
    }
}

