/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.TypeOfWork;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class WorkTicket {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="workTicket_id_seq")
    @SequenceGenerator(name="workTicket_id_seq", sequenceName="work_ticket_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @ManyToOne
    private Store currentLocation;
    @JsonProperty
    @ManyToOne
    private Store projectLocation;
    @JsonProperty
    @ManyToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee;
    @JsonProperty
    @ManyToOne
    private PortalUser portalUser;
    @JsonProperty
    private TypeOfWork typeOfWork;
    @JsonProperty
    private String isBillable;
    @JsonProperty
    private String notes;
    @JsonProperty
    private String equipmentNeeded;
    @JsonProperty
    private LocalDate supplyOrderDate;
    @JsonProperty
    private LocalDate projectStartDate;
    @JsonProperty
    private LocalDate projectEndDate;
    @JsonProperty
    private String orderNumber;
    @JsonProperty
    private Boolean supplyOrderSubmitted;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkTicket that = (WorkTicket)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.currentLocation, that.currentLocation) && Objects.equals(this.projectLocation, that.projectLocation) && Objects.equals(this.employee, that.employee) && Objects.equals(this.portalUser, that.portalUser) && this.typeOfWork == that.typeOfWork && Objects.equals(this.isBillable, that.isBillable) && Objects.equals(this.notes, that.notes) && Objects.equals(this.equipmentNeeded, that.equipmentNeeded) && Objects.equals(this.supplyOrderDate, that.supplyOrderDate) && Objects.equals(this.projectStartDate, that.projectStartDate) && Objects.equals(this.projectEndDate, that.projectEndDate) && Objects.equals(this.orderNumber, that.orderNumber) && Objects.equals(this.supplyOrderSubmitted, that.supplyOrderSubmitted) && Objects.equals(this.apiError, that.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", WorkTicket.class.getSimpleName() + "[", "]").add("id=" + this.id).add("currentLocation=" + String.valueOf(this.currentLocation)).add("projectLocation=" + String.valueOf(this.projectLocation)).add("employee=" + String.valueOf(this.employee)).add("portalUser=" + String.valueOf(this.portalUser)).add("typeOfWork=" + String.valueOf((Object)this.typeOfWork)).add("isBillable='" + this.isBillable + "'").add("notes='" + this.notes + "'").add("equipmentNeeded='" + this.equipmentNeeded + "'").add("supplyOrderDate=" + String.valueOf(this.supplyOrderDate)).add("projectStartDate=" + String.valueOf(this.projectStartDate)).add("projectEndDate=" + String.valueOf(this.projectEndDate)).add("orderNumber='" + this.orderNumber + "'").add("supplyOrderSubmitted=" + this.supplyOrderSubmitted).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.currentLocation, this.projectLocation, this.employee, this.portalUser, this.typeOfWork, this.isBillable, this.notes, this.equipmentNeeded, this.supplyOrderDate, this.projectStartDate, this.projectEndDate, this.orderNumber, this.supplyOrderSubmitted, this.apiError});
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setCurrentLocation(Store currentLocation) {
        this.currentLocation = currentLocation;
    }

    @JsonProperty
    public void setProjectLocation(Store projectLocation) {
        this.projectLocation = projectLocation;
    }

    @JsonProperty
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setTypeOfWork(TypeOfWork typeOfWork) {
        this.typeOfWork = typeOfWork;
    }

    @JsonProperty
    public void setIsBillable(String isBillable) {
        this.isBillable = isBillable;
    }

    @JsonProperty
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonProperty
    public void setEquipmentNeeded(String equipmentNeeded) {
        this.equipmentNeeded = equipmentNeeded;
    }

    @JsonProperty
    public void setSupplyOrderDate(LocalDate supplyOrderDate) {
        this.supplyOrderDate = supplyOrderDate;
    }

    @JsonProperty
    public void setProjectStartDate(LocalDate projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    @JsonProperty
    public void setProjectEndDate(LocalDate projectEndDate) {
        this.projectEndDate = projectEndDate;
    }

    @JsonProperty
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    @JsonProperty
    public void setSupplyOrderSubmitted(Boolean supplyOrderSubmitted) {
        this.supplyOrderSubmitted = supplyOrderSubmitted;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public Store getCurrentLocation() {
        return this.currentLocation;
    }

    public Store getProjectLocation() {
        return this.projectLocation;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public TypeOfWork getTypeOfWork() {
        return this.typeOfWork;
    }

    public String getIsBillable() {
        return this.isBillable;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getEquipmentNeeded() {
        return this.equipmentNeeded;
    }

    public LocalDate getSupplyOrderDate() {
        return this.supplyOrderDate;
    }

    public LocalDate getProjectStartDate() {
        return this.projectStartDate;
    }

    public LocalDate getProjectEndDate() {
        return this.projectEndDate;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public Boolean getSupplyOrderSubmitted() {
        return this.supplyOrderSubmitted;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

