/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.NonMnMileage;
import com.cbmportal.portal.domains.PerDiem;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.services.HotelService;
import com.cbmportal.portal.services.NonMnMileageService;
import com.cbmportal.portal.services.PerDiemService;
import com.cbmportal.portal.services.WorkTicketService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jsoup.helper.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/finance/"})
public class FinanceSubmissions {
    private final Logger log = LoggerFactory.getLogger(FinanceSubmissions.class);
    private final WorkTicketService workTicketService;
    private final HotelService hotelService;
    private final PerDiemService perDiemService;
    private final NonMnMileageService nonMnMileageService;

    public FinanceSubmissions(WorkTicketService workTicketService, HotelService hotelService, PerDiemService perDiemService, NonMnMileageService nonMnMileageService) {
        this.workTicketService = workTicketService;
        this.hotelService = hotelService;
        this.perDiemService = perDiemService;
        this.nonMnMileageService = nonMnMileageService;
    }

    @PostMapping(value={"workTicketSubmit"})
    ResponseEntity<FormSubmissionResponse> workTicketSubmit(@RequestBody WorkTicket wt, HttpServletResponse response) throws IOException {
        this.log.info(wt.toString());
        if (wt.getSupplyOrderSubmitted() != null && wt.getCurrentLocation() != null && wt.getProjectLocation() != null && wt.getEquipmentNeeded() != null && wt.getOrderNumber() != null && wt.getProjectEndDate() != null && wt.getProjectStartDate() != null && wt.getIsBillable() != null && wt.getTypeOfWork() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.workTicketService.processWorkTicket(wt, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("WorkTicket Form", false, new ApiError("submitWorkTicket", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"hotelSubmit"})
    ResponseEntity<FormSubmissionResponse> hotelSubmit(@RequestBody Hotel hotel, HttpServletResponse response) throws IOException {
        this.log.info(hotel.toString());
        if (hotel.getStore() != null && hotel.getPortalUser() != null && hotel.getHotelReason() != null && hotel.getCheckIn() != null && hotel.getCheckOut() != null && hotel.getNumOfBeds() != null && hotel.getNumOfRooms() != null && hotel.getWorkTicket() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.hotelService.requestHotel(hotel, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Hotel Form", false, new ApiError("submitHotel", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"perDiemSubmit"})
    ResponseEntity<FormSubmissionResponse> perDiemSubmit(@RequestBody PerDiem perDiem, HttpServletResponse response) throws IOException {
        this.log.info(perDiem.toString());
        MileageDate mileageDate = new MileageDate();
        if (perDiem.getMileageDates().size() == 1) {
            mileageDate = perDiem.getMileageDates().get(0);
        }
        if ((perDiem.getMileageDates().size() == 1 && (mileageDate.getDate() != null || mileageDate.getLocation1() != null || mileageDate.getLocation2() != null) || perDiem.getMileageDates().size() > 1) && perDiem.getEmployee() != null && perDiem.getPortalUser() != null && perDiem.getArrivalDate() != null && perDiem.getDepartureDate() != null && perDiem.getFirstHotelNight() != null && perDiem.getLastHotelNight() != null && perDiem.getReasonPayMissed() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.perDiemService.processPerDiem(perDiem, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("PerDiem Form", false, new ApiError("submitPerDiem", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"/nonMnMileageSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitMileage(@RequestBody @NotNull NonMnMileage mileage, HttpServletResponse response) throws IOException {
        this.log.info(mileage.toString());
        MileageDate mileageDate = new MileageDate();
        if (mileage.getMileageDates().size() == 1) {
            mileageDate = mileage.getMileageDates().get(0);
        }
        if ((mileage.getMileageDates().size() == 1 && (mileageDate.getDate() != null || mileageDate.getLocation1() != null || mileageDate.getLocation2() != null) || mileage.getMileageDates().size() > 1) && mileage.getEmployee() != null && mileage.getPortalUser() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.nonMnMileageService.processMileage(mileage, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Non MN Mileage Form", false, new ApiError("nonMnMileageSubmit", "Please fill in every field that has an * next to it.")));
    }
}

