/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.repositories.StoreRepository;
import com.cbmportal.portal.services.StoreService;
import org.springframework.stereotype.Service;

@Service
public class StoreServiceImpl
implements StoreService {
    private final StoreRepository storeRepository;

    public StoreServiceImpl(StoreRepository storeRepository) {
        this.storeRepository = storeRepository;
    }

    @Override
    public Iterable<Store> getStores() {
        return this.storeRepository.findAll();
    }

    @Override
    public Store getStoreById(Long id) {
        return this.storeRepository.findById(id).orElse(null);
    }

    @Override
    public Iterable<Store> getStoresByDistrict(District district) {
        return this.storeRepository.findStoresByDistrict(district);
    }

    @Override
    public Store createDistrictStore(Store store) {
        return (Store)this.storeRepository.save(store);
    }

    @Override
    public Store updateStore(Store store) {
        return (Store)this.storeRepository.save(store);
    }
}

