/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.PerDiem;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.PerDiemRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.PerDiemService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class PerDiemServiceImpl
implements PerDiemService {
    private final Logger log = LoggerFactory.getLogger(PerDiemServiceImpl.class);
    private final PerDiemRepository perDiemRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public PerDiemServiceImpl(PerDiemRepository perDiemRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.perDiemRepository = perDiemRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processPerDiem(PerDiem perDiem, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File perDiemHtml = new File(this.htmlFormLocation + "perdiem.html");
        StringBuilder mileageDatesHtml = new StringBuilder();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = perDiem.getEmployee().getEmployeeFirst() + " " + perDiem.getEmployee().getEmployeeLast();
        String pdfFileName = "perDiem-" + perDiem.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "perDiem/" + perDiem.getEmployee().getEmployeeNumber() + "/";
        this.listMileageEntries(perDiem.getMileageDates(), this.log, mileageDatesHtml);
        Document doc = Jsoup.parse((File)perDiemHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("location").html(perDiem.getStore().getStoreNum() + " " + perDiem.getStore().getName());
        doc.getElementsByClass("city").html(perDiem.getStore().getCity());
        doc.getElementsByClass("state").html(perDiem.getStore().getState());
        doc.getElementsByClass("employeeNum").html(perDiem.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("firstHotelNight").html(dateFormatter.format(perDiem.getFirstHotelNight()));
        doc.getElementsByClass("lastHotelNight").html(dateFormatter.format(perDiem.getLastHotelNight()));
        doc.getElementsByClass("arrivalDate").html(dateFormatter.format(perDiem.getArrivalDate()));
        doc.getElementsByClass("departureDate").html(dateFormatter.format(perDiem.getDepartureDate()));
        doc.getElementsByClass("mileageDates").html(mileageDatesHtml.toString());
        doc.getElementsByClass("reasonMissed").html(perDiem.getReasonPayMissed());
        doc.getElementsByClass("dm").html(perDiem.getPortalUser().getUserFirst() + " " + perDiem.getPortalUser().getUserLast());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Finance.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, perDiem.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                PerDiem savedPerDiem = (PerDiem)this.perDiemRepository.save(perDiem);
                if (savedPerDiem.getId() != null) {
                    formResponse.setFormName("PerDiem Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/finance/perDiemSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("PerDiem Form");
            formResponse.setSuccess(true);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    private void listMileageEntries(List<MileageDate> mileageDates, Logger log, StringBuilder mileageDatesHtml) {
        for (MileageDate mileageDate : mileageDates) {
            if (mileageDate.getLocation1() == null && mileageDate.getLocation2() == null) continue;
            mileageDatesHtml.append("<div class=mileage-date-info>").append(mileageDate.getDate()).append("</div>");
            mileageDatesHtml.append("<div class=mileage-departed-info>").append(mileageDate.getLocation1().getStoreNum()).append(" ").append(mileageDate.getLocation1().getName()).append("</div>");
            mileageDatesHtml.append("<div class=mileage-destination-store-info>").append(mileageDate.getLocation2().getStoreNum()).append(" ").append(mileageDate.getLocation2().getName()).append("</div>");
            mileageDatesHtml.append("<div class=rt-ow-info>").append((Object)mileageDate.getRt_ow()).append("</div>");
        }
    }
}

