/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.services.EmailService;
import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl
implements EmailService {
    final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    private final JavaMailSenderImpl emailSender;

    public EmailServiceImpl(JavaMailSenderImpl emailSender) {
        this.emailSender = emailSender;
    }

    @Override
    public void sendMessageNewHire(String to, String subject, String pdf, File idBadge, File govIdFront, File govIdRear, File ssnCard, String portalUserEmail) {
        MimeMessage message = this.emailSender.createMimeMessage();
        File pdfFile = new File(pdf);
        String[] ccEmails = new String[]{portalUserEmail, "joseph.schaeppi@carlsonbuilding.com"};
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            this.setMailProperties(to, subject, pdfFile, ccEmails, helper);
            helper.addAttachment(idBadge.getName(), idBadge);
            helper.addAttachment(govIdFront.getName(), govIdFront);
            helper.addAttachment(govIdRear.getName(), govIdRear);
            helper.addAttachment(ssnCard.getName(), ssnCard);
            this.emailSender.send(message);
        }
        catch (MessagingException mExc) {
            this.log.error(mExc.getMessage());
        }
    }

    @Override
    public void sendMessage(String to, String subject, String pdf, String portalUserEmail) {
        MimeMessage message = this.emailSender.createMimeMessage();
        File pdfFile = new File(pdf);
        String[] ccEmails = new String[]{portalUserEmail, "joseph.schaeppi@carlsonbuilding.com"};
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            this.setMailProperties(to, subject, pdfFile, ccEmails, helper);
            this.emailSender.send(message);
        }
        catch (MessagingException mExc) {
            this.log.error(mExc.getMessage());
        }
    }

    private void setMailProperties(String to, String subject, File pdfFile, String[] ccEmails, MimeMessageHelper helper) throws MessagingException {
        helper.setFrom("CBM IT <cbmmailer@carlsonbuilding.com>");
        helper.setTo(to);
        helper.setCc(ccEmails);
        helper.setSubject(subject);
        helper.setText(pdfFile.getName() + " file attached.");
        FileSystemResource resource = new FileSystemResource(pdfFile);
        helper.addAttachment(pdfFile.getName(), (InputStreamSource)resource);
    }
}

