/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains.VO;

import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.UserPermission;
import com.cbmportal.portal.domains.UserRole;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;

public class AuthUser {
    @JsonProperty
    private Long id;
    @JsonProperty
    private UserPermission permission;
    @JsonProperty
    @Column(unique=true)
    private String userName;
    @JsonProperty
    private String userFirst;
    @JsonProperty
    private String userLast;
    @JsonIgnore
    private String password;
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<UserRole> authorities;
    @JsonProperty
    private String email;
    @JsonProperty
    @ManyToMany
    private List<District> district;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public AuthUser(UserPermission permission, String userName, String userFirst, String userLast, Set<UserRole> authorities, String email, List<District> district) {
        this.permission = permission;
        this.userName = userName;
        this.userFirst = userFirst;
        this.userLast = userLast;
        this.authorities = authorities;
        this.email = email;
        this.district = district;
    }

    public AuthUser() {
    }

    public AuthUser(Long id, UserPermission permission, String userName, String userFirst, String userLast, String password, Set<UserRole> authorities, String email, List<District> district) {
        this.id = id;
        this.permission = permission;
        this.userName = userName;
        this.userFirst = userFirst;
        this.userLast = userLast;
        this.password = password;
        this.authorities = authorities;
        this.email = email;
        this.district = district;
    }

    public String toString() {
        return new StringJoiner(", ", AuthUser.class.getSimpleName() + "[", "]").add("permission=" + String.valueOf((Object)this.permission)).add("userName='" + this.userName + "'").add("userFirst='" + this.userFirst + "'").add("userLast='" + this.userLast + "'").add("authorities=" + String.valueOf(this.authorities)).add("email='" + this.email + "'").add("district=" + String.valueOf(this.district)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public Long getId() {
        return this.id;
    }

    public UserPermission getPermission() {
        return this.permission;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserFirst() {
        return this.userFirst;
    }

    public String getUserLast() {
        return this.userLast;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<UserRole> getAuthorities() {
        return this.authorities;
    }

    public String getEmail() {
        return this.email;
    }

    public List<District> getDistrict() {
        return this.district;
    }

    public ApiError getApiError() {
        return this.apiError;
    }

    @JsonProperty
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setPermission(UserPermission permission) {
        this.permission = permission;
    }

    @JsonProperty
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty
    public void setUserFirst(String userFirst) {
        this.userFirst = userFirst;
    }

    @JsonProperty
    public void setUserLast(String userLast) {
        this.userLast = userLast;
    }

    @JsonIgnore
    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthorities(Set<UserRole> authorities) {
        this.authorities = authorities;
    }

    @JsonProperty
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty
    public void setDistrict(List<District> district) {
        this.district = district;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }
}

