/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.UserPermission;
import com.cbmportal.portal.domains.UserRole;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.WorkTicket;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
public class PortalUser
implements UserDetails {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="portalUser_id_seq")
    @SequenceGenerator(name="portalUser_id_seq", sequenceName="portal_user_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    private UserPermission permission;
    @JsonProperty
    @Column(unique=true)
    private String userName;
    @JsonProperty
    private String userFirst;
    @JsonProperty
    private String userLast;
    @JsonProperty
    private String password;
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<UserRole> authorities;
    @JsonProperty
    private String email;
    @JsonIgnore
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<TargetOrder> targetOrder;
    @JsonIgnore
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<WorkTicket> workTickets;
    @JsonProperty
    @ManyToMany
    private List<District> district;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public PortalUser() {
        this.authorities = new HashSet<UserRole>();
    }

    public PortalUser(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public PortalUser(Long id, String userName, String password, Set<UserRole> authorities) {
        this.userName = userName;
        this.password = password;
        this.authorities = authorities;
    }

    public PortalUser(UserPermission permission, String userName, String userFirst, String userLast, String password, String email, List<District> district, ApiError apiError) {
        this.permission = permission;
        this.userName = userName;
        this.userFirst = userFirst;
        this.userLast = userLast;
        this.password = password;
        this.email = email;
        this.district = district;
        this.apiError = apiError;
    }

    public PortalUser(String username, String encodedPassword, Set<UserRole> authorities) {
        this.userName = username;
        this.password = encodedPassword;
        this.authorities = authorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortalUser that = (PortalUser)o;
        return Objects.equals(this.id, that.id) && this.permission == that.permission && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && this.district == that.district && Objects.equals(this.apiError, that.apiError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.permission, this.userName, this.password, this.district, this.apiError});
    }

    public String toString() {
        return new StringJoiner(", ", PortalUser.class.getSimpleName() + "[", "]").add("id=" + this.id).add("permission=" + String.valueOf((Object)this.permission)).add("userName='" + this.userName + "'").add("userFirst='" + this.userFirst + "'").add("userLast='" + this.userLast + "'").add("password='" + this.password + "'").add("email='" + this.email + "'").add("district=" + String.valueOf(this.district)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public Set<UserRole> getAuthorities() {
        return this.authorities;
    }

    public String getUsername() {
        return this.userName;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Long getId() {
        return this.id;
    }

    public UserPermission getPermission() {
        return this.permission;
    }

    public String getUserFirst() {
        return this.userFirst;
    }

    public String getUserLast() {
        return this.userLast;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public List<TargetOrder> getTargetOrder() {
        return this.targetOrder;
    }

    public List<WorkTicket> getWorkTickets() {
        return this.workTickets;
    }

    public List<District> getDistrict() {
        return this.district;
    }

    public ApiError getApiError() {
        return this.apiError;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setPermission(UserPermission permission) {
        this.permission = permission;
    }

    @JsonProperty
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty
    public void setUserFirst(String userFirst) {
        this.userFirst = userFirst;
    }

    @JsonProperty
    public void setUserLast(String userLast) {
        this.userLast = userLast;
    }

    @JsonProperty
    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthorities(Set<UserRole> authorities) {
        this.authorities = authorities;
    }

    @JsonProperty
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonIgnore
    public void setTargetOrder(List<TargetOrder> targetOrder) {
        this.targetOrder = targetOrder;
    }

    @JsonIgnore
    public void setWorkTickets(List<WorkTicket> workTickets) {
        this.workTickets = workTickets;
    }

    @JsonProperty
    public void setDistrict(List<District> district) {
        this.district = district;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }
}

