/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Store;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;

@Entity
public class BonusDate {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bonusDate_id_seq")
    @SequenceGenerator(name="bonusDate_id_seq", sequenceName="bonus_date_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    private LocalDate date;
    @JsonProperty
    @ManyToOne
    private Store store;
    @JsonProperty
    private Double bonus;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BonusDate bonusDate = (BonusDate)o;
        return Objects.equals(this.id, bonusDate.id) && Objects.equals(this.date, bonusDate.date) && Objects.equals(this.store, bonusDate.store) && Objects.equals(this.bonus, bonusDate.bonus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.date, this.store, this.bonus);
    }

    public String toString() {
        return new StringJoiner(", ", BonusDate.class.getSimpleName() + "[", "]").add("id=" + this.id).add("date=" + String.valueOf(this.date)).add("store=" + String.valueOf(this.store)).add("bonus=" + this.bonus).toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setDate(LocalDate date) {
        this.date = date;
    }

    @JsonProperty
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    public void setBonus(Double bonus) {
        this.bonus = bonus;
    }

    public Long getId() {
        return this.id;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public Store getStore() {
        return this.store;
    }

    public Double getBonus() {
        return this.bonus;
    }
}

