/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.PortalUserSafeVO;
import com.cbmportal.portal.services.PSService;
import com.cbmportal.portal.services.PortalUserService;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin"})
@CrossOrigin
public class Admin {
    Logger log = LoggerFactory.getLogger(Admin.class);
    private final PortalUserService portalUserService;
    private final PSService psService;

    public Admin(PortalUserService portalUserService, PSService psService) {
        this.portalUserService = portalUserService;
        this.psService = psService;
    }

    @GetMapping(value={"/getPortalUser"})
    public ResponseEntity<PortalUser> getDm(@RequestParam(value="username") String username) {
        PortalUser retrieveUser = this.portalUserService.getDm(username);
        return ResponseEntity.ok().body((Object)retrieveUser);
    }

    @PostMapping(value={"/createPortalUser"})
    public ResponseEntity<PortalUser> createPortalUser(@RequestBody PortalUser portalUser, HttpServletResponse response) {
        PortalUser savedUser = this.portalUserService.createPortalUser(portalUser, response);
        return ResponseEntity.status((int)response.getStatus()).body((Object)savedUser);
    }

    @PostMapping
    @RequestMapping(value={"/createPS"})
    public ResponseEntity<PS> createDM(@RequestBody PS ps, HttpServletResponse response) {
        PS savedPS = this.psService.createPS(ps, response);
        return ResponseEntity.status((int)response.getStatus()).body((Object)savedPS);
    }

    @PutMapping(value={"/updatePortalUser"})
    public ResponseEntity<PortalUserSafeVO> updatePortalUser(@RequestBody PortalUser portalUser) {
        return ResponseEntity.ok().body((Object)this.portalUserService.updatePortalUser(portalUser));
    }

    @PutMapping(value={"/updatePS"})
    public ResponseEntity<PS> updatePS(@RequestBody PS ps) {
        PS updatedPS = this.psService.updatePS(ps);
        PortalUserSafeVO portalUserSafeVO = new PortalUserSafeVO();
        portalUserSafeVO.setUserName(updatedPS.getPortalUser().getUsername());
        portalUserSafeVO.setId(updatedPS.getPortalUser().getId());
        portalUserSafeVO.setUserFirst(updatedPS.getPortalUser().getUserFirst());
        portalUserSafeVO.setEmail(updatedPS.getPortalUser().getEmail());
        portalUserSafeVO.setUserLast(updatedPS.getPortalUser().getUserLast());
        updatedPS.setUserSafeVO(portalUserSafeVO);
        return ResponseEntity.ok().body((Object)updatedPS);
    }
}

