/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.UserPermission;
import com.cbmportal.portal.domains.UserRole;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.repositories.UserRoleRepository;
import java.util.HashSet;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.crypto.password.PasswordEncoder;

@AutoConfiguration
@EnableConfigurationProperties(value={CustomProperties.class})
@SpringBootApplication
public class CbmPortalApplication {
    public static void main(String[] args) {
        SpringApplication.run(CbmPortalApplication.class, (String[])args);
    }

    @Bean
    CommandLineRunner run(UserRoleRepository userRoleRepository, PortalUserRepository portalUserRepository, PasswordEncoder passwordEncoder) {
        return args -> {
            if (userRoleRepository.findByAuthority(UserPermission.Admin.name()).isPresent()) {
                return;
            }
            UserRole adminRole = (UserRole)userRoleRepository.save(new UserRole(UserPermission.Admin.name()));
            userRoleRepository.save(new UserRole(UserPermission.DM.name()));
            HashSet<UserRole> roles = new HashSet<UserRole>();
            roles.add(adminRole);
            PortalUser admin = new PortalUser(23L, "admin", passwordEncoder.encode((CharSequence)"password"), roles);
            portalUserRepository.save(admin);
        };
    }
}

