/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.util;

import com.cbmportal.portal.exceptions.FormProcessingException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PdfStorageHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfStorageHelper.class);

    public String buildAndPrepare(String base, String ... subfolders) {
        if (base == null || base.isBlank()) {
            throw new IllegalStateException("cbm.pdfFiles configuration is missing");
        }
        Path basePath = Paths.get(base, new String[0]).toAbsolutePath().normalize();
        ArrayList<String> sanitized = new ArrayList<String>();
        for (String s : subfolders) {
            sanitized.add(this.sanitizeSegment(s));
        }
        Path target = Paths.get(basePath.toString(), sanitized.toArray(new String[0]));
        try {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FormProcessingException("Failed to create directory: " + String.valueOf(target), e);
        }
        String finalPath = target.toString() + File.separator;
        log.debug("Prepared PDF directory: {}", (Object)finalPath);
        return finalPath;
    }

    public Path buildSubDirectory(String base, String ... subfolders) {
        if (base == null || base.isBlank()) {
            throw new IllegalStateException("cbm.pdfFiles configuration is missing");
        }
        Path basePath = Paths.get(base, new String[0]).toAbsolutePath().normalize();
        ArrayList<String> sanitized = new ArrayList<String>();
        for (String s : subfolders) {
            sanitized.add(this.sanitizeSegment(s));
        }
        Path target = Paths.get(basePath.toString(), sanitized.toArray(new String[0]));
        try {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FormProcessingException("Failed to create directory: " + String.valueOf(target), e);
        }
        return target;
    }

    private String sanitizeSegment(String raw) {
        if (raw == null || raw.isBlank()) {
            return "unknown";
        }
        return raw.replaceAll("[^a-zA-Z0-9._-]", "_");
    }
}

