/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class FormTypeResolver {
    private static final Map<String, FormType> ALIAS_MAP = Arrays.stream(FormType.values()).flatMap(ft -> ft.getAliases().stream().map(alias -> Map.entry(alias, ft))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    private FormTypeResolver() {
    }

    public static Optional<FormType> resolve(String formName) {
        if (formName == null || formName.isBlank()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ALIAS_MAP.get(formName.trim().toLowerCase()));
    }

    public static List<String> getValidOptions() {
        return Arrays.stream(FormType.values()).map(FormType::getPrimaryAlias).collect(Collectors.toList());
    }

    public static <T> Optional<T> executeForFormType(String formName, Map<FormType, Supplier<T>> handlers) {
        return FormTypeResolver.resolve(formName).map(handlers::get).map(Supplier::get);
    }

    public static enum FormType {
        BACK_PAY("backpay", "back_pay", "back-pay"),
        BONUS("bonus"),
        HOTEL("hotel"),
        MILEAGE("mileage"),
        PTO("pto"),
        NEW_HIRE("newhire", "new_hire", "new-hire"),
        PER_DIEM("perdiem", "per_diem", "per-diem"),
        TERMINATION("termination"),
        TARGET_ORDER("targetorder", "target_order", "target-order"),
        UNIFORM("uniform"),
        WORK_TICKET("workticket", "work_ticket", "work-ticket"),
        NON_MN_MILEAGE("nonmnmileage", "non_mn_mileage", "non-mn-mileage"),
        TIME_ADJUSTMENT("timeadjustment", "time_adjustment", "time-adjustment");

        private final List<String> aliases;

        private FormType(String ... aliases) {
            this.aliases = Arrays.asList(aliases);
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public String getPrimaryAlias() {
            return this.aliases.isEmpty() ? this.name().toLowerCase() : this.aliases.get(0);
        }
    }
}

