/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.util;

import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.HotelReason;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.NonMnMileage;
import com.cbmportal.portal.domains.PerDiem;
import com.cbmportal.portal.domains.TypeOfWork;
import com.cbmportal.portal.domains.VO.HotelRequestDTO;
import com.cbmportal.portal.domains.VO.MileageDateDTO;
import com.cbmportal.portal.domains.VO.NonMnMileageRequestDTO;
import com.cbmportal.portal.domains.VO.PerDiemRequestDTO;
import com.cbmportal.portal.domains.VO.WorkTicketRequestDTO;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.repositories.PSRepository;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class FormDtoMapper {
    private final PSRepository psRepository;

    public FormDtoMapper(PSRepository psRepository) {
        this.psRepository = psRepository;
    }

    public WorkTicket toWorkTicket(WorkTicketRequestDTO dto) {
        if (dto == null) {
            return null;
        }
        WorkTicket wt = new WorkTicket();
        wt.setCurrentLocation(dto.getCurrentLocation());
        wt.setProjectLocation(dto.getProjectLocation());
        wt.setEmployee(dto.getEmployee());
        wt.setPortalUser(dto.getPortalUser());
        wt.setIsBillable(dto.getIsBillable());
        wt.setNotes(dto.getNotes());
        wt.setEquipmentNeeded(dto.getEquipmentNeeded());
        wt.setSupplyOrderDate(dto.getSupplyOrderDate());
        wt.setProjectStartDate(dto.getProjectStartDate());
        wt.setProjectEndDate(dto.getProjectEndDate());
        wt.setOrderNumber(dto.getOrderNumber());
        wt.setSupplyOrderSubmitted(dto.getSupplyOrderSubmitted());
        if (dto.getTypeOfWork() != null) {
            wt.setTypeOfWork(TypeOfWork.fromString(dto.getTypeOfWork()));
        }
        return wt;
    }

    public Hotel toHotel(HotelRequestDTO dto) {
        if (dto == null) {
            return null;
        }
        Hotel hotel = new Hotel();
        hotel.setPortalUser(dto.getPortalUser());
        hotel.setStore(dto.getStore());
        hotel.setCheckIn(dto.getCheckIn());
        hotel.setCheckOut(dto.getCheckOut());
        hotel.setNumOfRooms(dto.getNumOfRooms());
        hotel.setNumOfBeds(dto.getNumOfBeds());
        hotel.setNewPS(dto.getNewPS());
        hotel.setWorkTicket(dto.getWorkTicket());
        hotel.setComments(dto.getComments());
        hotel.setPs2(dto.getPs2());
        hotel.setPs1(dto.getPs1());
        if (dto.getHotelReason() != null) {
            hotel.setHotelReason(HotelReason.valueOf(dto.getHotelReason()));
        }
        return hotel;
    }

    public PerDiem toPerDiem(PerDiemRequestDTO dto) {
        if (dto == null) {
            return null;
        }
        PerDiem perDiem = new PerDiem();
        perDiem.setStore(dto.getStore());
        perDiem.setMileageDates(this.toMileageDateList(dto.getMileageDates()));
        perDiem.setFirstHotelNight(dto.getFirstHotelNight());
        perDiem.setLastHotelNight(dto.getLastHotelNight());
        perDiem.setArrivalDate(dto.getArrivalDate());
        perDiem.setDepartureDate(dto.getDepartureDate());
        perDiem.setReasonPayMissed(dto.getReasonPayMissed());
        perDiem.setEmployee(dto.getEmployee());
        perDiem.setPortalUser(dto.getPortalUser());
        return perDiem;
    }

    public NonMnMileage toNonMnMileage(NonMnMileageRequestDTO dto) {
        if (dto == null) {
            return null;
        }
        NonMnMileage mileage = new NonMnMileage();
        mileage.setComments(dto.getComments());
        mileage.setEmployee(dto.getEmployee());
        mileage.setPortalUser(dto.getPortalUser());
        mileage.setMileageDates(this.toMileageDateList(dto.getMileageDates()));
        return mileage;
    }

    public List<MileageDate> toMileageDateList(List<MileageDateDTO> dtoList) {
        if (dtoList == null) {
            return new ArrayList<MileageDate>();
        }
        ArrayList<MileageDate> result = new ArrayList<MileageDate>(dtoList.size());
        for (MileageDateDTO dto : dtoList) {
            result.add(this.toMileageDate(dto));
        }
        return result;
    }

    public MileageDate toMileageDate(MileageDateDTO dto) {
        if (dto == null) {
            return null;
        }
        MileageDate md = new MileageDate();
        md.setDate(dto.getDate());
        md.setLocation1(dto.getLocation1());
        md.setLocation2(dto.getLocation2());
        md.setRt_ow(dto.getRt_ow());
        return md;
    }
}

