/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Uniform;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.UniformRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.UniformService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.HtmlFragmentBuilder;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UniformServiceImpl
extends AbstractFormProcessingService<Uniform>
implements UniformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UniformServiceImpl.class);
    private final HtmlFragmentBuilder htmlBuilder;

    public UniformServiceImpl(UniformRepository uniformRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper, HtmlFragmentBuilder htmlBuilder) {
        super(pdfBuilderService, emailService, uniformRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.htmlBuilder = htmlBuilder;
    }

    @Override
    public FormSubmissionResponse processUniform(Uniform uniform) {
        return this.processForm(uniform);
    }

    @Override
    protected void validateFormData(Uniform uniform) {
        if (uniform == null) {
            throw new FormProcessingException("Uniform data cannot be null");
        }
        if (uniform.getEmployee() == null || uniform.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (uniform.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (uniform.getQuantity() == null || uniform.getQuantity() <= 0) {
            throw new FormProcessingException("Quantity must be greater than zero");
        }
    }

    @Override
    protected FormContext buildFormContext(Uniform uniform) {
        String fullEmployeeName = uniform.getEmployee().getEmployeeFirst() + " " + uniform.getEmployee().getEmployeeLast();
        String empNum = uniform.getEmployee().getEmployeeNumber().toString();
        String hrEmail = this.getDepartmentEmail("HR", "Uniform");
        return FormContext.builder().employee(uniform.getEmployee()).pdfFileName("uniform-" + empNum + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation("uniform", empNum)).recipients(List.of(hrEmail, uniform.getPortalUser().getEmail())).emailSubject("Uniform Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum)).portalUserName(uniform.getPortalUser().getUserFirst() + " " + uniform.getPortalUser().getUserLast()).formType("UNIFORM").build();
    }

    @Override
    protected Document generateHtmlDocument(FormContext context, Uniform uniform) throws IOException {
        File uniformHtml = new File(this.htmlFormLocation + "uniform.html");
        Document doc = Jsoup.parse((File)uniformHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("employeeNum").html(String.valueOf(context.getEmployee().getEmployeeNumber()));
        doc.getElementsByClass("employeeFirstName").html(context.getEmployee().getEmployeeFirst());
        doc.getElementsByClass("employeeLastName").html(context.getEmployee().getEmployeeLast());
        doc.getElementsByClass("address1").html(context.getEmployee().getAddress().getAddress1());
        doc.getElementsByClass("address2").html(context.getEmployee().getAddress().getAddress2() != null ? context.getEmployee().getAddress().getAddress2() : "");
        doc.getElementsByClass("city").html(context.getEmployee().getAddress().getCity());
        doc.getElementsByClass("state").html(context.getEmployee().getAddress().getState());
        doc.getElementsByClass("zip").html(context.getEmployee().getAddress().getZip());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("size").html(uniform.getSize() != null ? uniform.getSize().toString() : "");
        doc.getElementsByClass("quantity").html(uniform.getQuantity().toString());
        doc.getElementsByClass("total").html(uniform.getTotal().toString());
        doc.getElementsByClass("EESignature").html(this.htmlBuilder.signatureImage(uniform.getSig(), "Employee signature"));
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    @Override
    protected String getFormName() {
        return "Uniform Form";
    }

    @Override
    protected Long getEntityId(Uniform entity) {
        return entity.getId();
    }

    @Override
    protected void setSubmittedDate(Uniform uniform) {
        uniform.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber) {
        return this.htmlBuilder.simpleEmailBody("Uniform Form", employeeName, employeeNumber);
    }
}

