/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.TimeAdjustBreak;
import com.cbmportal.portal.domains.TimeAdjustment;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.DatabaseOperationException;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.TimeAdjustmentRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.TimeAdjustmentService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.DepartmentEmailHelper;
import com.cbmportal.portal.services.util.HtmlFragmentBuilder;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class TimeAdjustmentServiceImpl
implements TimeAdjustmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeAdjustmentServiceImpl.class);
    private final TimeAdjustmentRepository timeAdjustmentRepository;
    private final MicrosoftGraphEmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final CustomProperties customProperties;
    private final PdfStorageHelper pdfStorageHelper;
    private final HtmlFragmentBuilder htmlBuilder;
    private final DepartmentEmailHelper emailHelper;
    private final String htmlFormLocation;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-yyyy");
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("MM-dd-yyyy hh:mm a");

    public TimeAdjustmentServiceImpl(TimeAdjustmentRepository timeAdjustmentRepository, MicrosoftGraphEmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper, HtmlFragmentBuilder htmlBuilder, DepartmentEmailHelper emailHelper) {
        this.timeAdjustmentRepository = timeAdjustmentRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
        this.htmlBuilder = htmlBuilder;
        this.emailHelper = emailHelper;
    }

    @Override
    public FormSubmissionResponse processTimeAdjustment(TimeAdjustment timeAdjustment) {
        try {
            FormContext context = this.buildFormContext(timeAdjustment);
            Document doc = this.generateHtmlDocument(context, timeAdjustment);
            File pdfFile = new File(context.getPdfSaveLocation() + context.getPdfFileName());
            this.pdfBuilderService.generatePdf(context.getPdfSaveLocation(), context.getPdfFileName(), doc);
            if (!pdfFile.exists() || pdfFile.isDirectory()) {
                throw new FormProcessingException("Failed to generate PDF file: " + context.getPdfFileName());
            }
            log.info("PDF file created successfully: {}", (Object)context.getPdfFileName());
            this.sendEmailNotification(context, pdfFile);
            timeAdjustment.setSubmittedDate(LocalDateTime.now());
            TimeAdjustment savedTimeAdjustment = (TimeAdjustment)this.timeAdjustmentRepository.save(timeAdjustment);
            if (savedTimeAdjustment.getId() == null) {
                throw new DatabaseOperationException("Failed to save time adjustment record");
            }
            FormSubmissionResponse formResponse = new FormSubmissionResponse();
            formResponse.setFormName("Time Adjustment Form");
            formResponse.setSuccess(true);
            return formResponse;
        }
        catch (IOException ioExc) {
            log.error("IO error processing time adjustment form", (Throwable)ioExc);
            throw new FormProcessingException("Error generating or sending time adjustment form", ioExc);
        }
        catch (DataAccessException dbExc) {
            log.error("Database error processing time adjustment form", (Throwable)dbExc);
            throw new DatabaseOperationException("Failed to save time adjustment data", dbExc);
        }
        catch (NullPointerException npe) {
            log.error("Null pointer error processing time adjustment form", (Throwable)npe);
            throw new FormProcessingException("Missing required data in time adjustment form", npe);
        }
    }

    private FormContext buildFormContext(TimeAdjustment timeAdjustment) throws IOException {
        String fullEmployeeName = timeAdjustment.getEmployee().getEmployeeFirst() + " " + timeAdjustment.getEmployee().getEmployeeLast();
        String empNum = timeAdjustment.getEmployee().getEmployeeNumber().toString();
        String payrollEmail = this.emailHelper.getEmail("Payroll", "Time Adjustment");
        String base = this.customProperties.getPdfFiles();
        if (base == null || base.isBlank()) {
            throw new IOException("cbm.pdfFiles configuration is missing");
        }
        String pdfSaveLocation = this.pdfStorageHelper.buildAndPrepare(base, "timeAdjust", empNum);
        return FormContext.builder().employee(timeAdjustment.getEmployee()).pdfFileName("timeAdjustment-" + empNum + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(pdfSaveLocation).recipients(List.of(payrollEmail, timeAdjustment.getPortalUser().getEmail())).emailSubject("Time Adjustment Form - " + fullEmployeeName).emailBody(this.htmlBuilder.simpleEmailBody("Time Adjustment Form", fullEmployeeName, empNum)).portalUserName(timeAdjustment.getPortalUser().getUserFirst() + " " + timeAdjustment.getPortalUser().getUserLast()).formType("TIME_ADJUSTMENT").build();
    }

    private Document generateHtmlDocument(FormContext context, TimeAdjustment timeAdjustment) throws IOException {
        File adjustInfo = new File(this.htmlFormLocation + "timeadjustment.html");
        Document doc = Jsoup.parse((File)adjustInfo, (String)"UTF-8", (String)"");
        StringBuilder breakInfo = new StringBuilder();
        for (TimeAdjustBreak breaks : timeAdjustment.getBreaks()) {
            long totalHours = Duration.between(breaks.getPunchIn(), breaks.getPunchOut()).toHours();
            double adjustedHours = (double)totalHours - breaks.getBreakAmount();
            breakInfo.append(this.htmlBuilder.timeAdjustmentRow(breaks.getDate(), breaks.getPunchIn(), breaks.getPunchOut(), totalHours, breaks.getBreakAmount(), adjustedHours, this.dateFormatter, this.timeFormatter));
        }
        doc.getElementsByClass("breakInfo").html(breakInfo.toString());
        doc.getElementsByClass("employeeNum").html(String.valueOf(context.getEmployee().getEmployeeNumber()));
        doc.getElementsByClass("employeeName").html(context.getEmployee().getEmployeeFirst() + " " + context.getEmployee().getEmployeeLast());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("reasonMissed").html(this.htmlBuilder.valueOrDefault(timeAdjustment.getReasonMissed(), ""));
        doc.getElementsByClass("employeeSig").html(this.htmlBuilder.signatureImage(timeAdjustment.getEmployeeSig(), "Employee signature"));
        doc.getElementsByClass("dmSig").html(this.htmlBuilder.signatureImage(timeAdjustment.getManagerSig(), "Manager signature"));
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    private void sendEmailNotification(FormContext context, File pdfFile) {
        this.emailService.sendEmail(context.getRecipients(), context.getEmailSubject(), context.getEmailBody(), pdfFile);
    }
}

