/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.RefreshToken;
import com.cbmportal.portal.domains.VO.SessionInfoVO;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.repositories.RefreshTokenRepository;
import com.cbmportal.portal.services.SecurityNotificationService;
import com.cbmportal.portal.services.SessionManagementService;
import com.cbmportal.portal.services.impl.DeviceInfoService;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SessionManagementServiceImpl
implements SessionManagementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionManagementServiceImpl.class);
    private final RefreshTokenRepository refreshTokenRepository;
    private final PortalUserRepository portalUserRepository;
    private final DeviceInfoService deviceInfoService;
    private final SecurityNotificationService securityNotificationService;

    public SessionManagementServiceImpl(RefreshTokenRepository refreshTokenRepository, PortalUserRepository portalUserRepository, DeviceInfoService deviceInfoService, SecurityNotificationService securityNotificationService) {
        this.refreshTokenRepository = refreshTokenRepository;
        this.portalUserRepository = portalUserRepository;
        this.deviceInfoService = deviceInfoService;
        this.securityNotificationService = securityNotificationService;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SessionInfoVO> getUserSessions(String username) {
        log.debug("Fetching sessions for user: {}", (Object)username);
        PortalUser user = this.portalUserRepository.findPortalUserByUserName(username).orElseThrow(() -> new IllegalArgumentException("User not found: " + username));
        List<RefreshToken> activeSessions = this.refreshTokenRepository.findByUserAndRevokedFalseAndExpiresAtAfter(user, Instant.now());
        return activeSessions.stream().map(this::mapToSessionInfoVO).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true)
    public List<SessionInfoVO> getAllActiveSessions() {
        log.debug("Fetching all active sessions");
        List allTokens = this.refreshTokenRepository.findAll();
        return allTokens.stream().filter(token -> !token.isRevoked() && !token.isExpired()).map(this::mapToSessionInfoVO).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void revokeSession(Long tokenId) {
        this.revokeAnySession(tokenId);
    }

    @Override
    @Transactional
    public void revokeUserSession(String username, Long tokenId) {
        log.info("Revoking session with ID: {} for user: {}", (Object)tokenId, (Object)username);
        PortalUser user = this.portalUserRepository.findPortalUserByUserName(username).orElseThrow(() -> new IllegalArgumentException("User not found: " + username));
        RefreshToken token = (RefreshToken)this.refreshTokenRepository.findById(tokenId).orElseThrow(() -> new IllegalArgumentException("Session not found with ID: " + tokenId));
        if (!token.getUser().getId().equals(user.getId())) {
            log.warn("User {} attempted to revoke session {} not owned by them", (Object)username, (Object)tokenId);
            throw new AccessDeniedException("You are not allowed to revoke this session");
        }
        if (token.isRevoked()) {
            log.debug("Session {} is already revoked", (Object)tokenId);
            return;
        }
        token.setRevoked(true);
        this.refreshTokenRepository.save(token);
        log.info("Session {} revoked for user: {}", (Object)tokenId, (Object)username);
        try {
            this.securityNotificationService.notifySessionRevoked(token.getUser(), token.getDeviceInfo(), "User");
        }
        catch (Exception e) {
            log.error("Failed to send session revoked notification", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void revokeAnySession(Long tokenId) {
        log.info("Admin revoking session with ID: {}", (Object)tokenId);
        RefreshToken token = (RefreshToken)this.refreshTokenRepository.findById(tokenId).orElseThrow(() -> new IllegalArgumentException("Session not found with ID: " + tokenId));
        if (token.isRevoked()) {
            log.debug("Session {} is already revoked", (Object)tokenId);
            return;
        }
        token.setRevoked(true);
        this.refreshTokenRepository.save(token);
        log.info("Session {} revoked for user: {} by admin", (Object)tokenId, (Object)token.getUser().getUsername());
        try {
            this.securityNotificationService.notifySessionRevoked(token.getUser(), token.getDeviceInfo(), "Administrator");
        }
        catch (Exception e) {
            log.error("Failed to send session revoked notification", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void revokeAllUserSessionsExceptCurrent(String username, Long currentTokenId) {
        log.info("Revoking all sessions for user: {} except token ID: {}", (Object)username, (Object)currentTokenId);
        PortalUser user = this.portalUserRepository.findPortalUserByUserName(username).orElseThrow(() -> new IllegalArgumentException("User not found: " + username));
        List<RefreshToken> userTokens = this.refreshTokenRepository.findByUser(user);
        int revokedCount = 0;
        for (RefreshToken token : userTokens) {
            if (token.getId().equals(currentTokenId) || token.isRevoked()) continue;
            token.setRevoked(true);
            this.refreshTokenRepository.save(token);
            ++revokedCount;
        }
        log.info("Revoked {} sessions for user: {}", (Object)revokedCount, (Object)username);
    }

    @Override
    @Transactional
    public int cleanupExpiredTokens() {
        log.info("Starting cleanup of expired refresh tokens");
        List allTokens = this.refreshTokenRepository.findAll();
        int deletedCount = 0;
        for (RefreshToken token : allTokens) {
            if (!token.isExpired()) continue;
            this.refreshTokenRepository.delete(token);
            ++deletedCount;
        }
        log.info("Cleanup complete. Deleted {} expired tokens", (Object)deletedCount);
        return deletedCount;
    }

    @Override
    @Transactional(readOnly=true)
    public int getActiveSessionCount(String username) {
        PortalUser user = this.portalUserRepository.findPortalUserByUserName(username).orElseThrow(() -> new IllegalArgumentException("User not found: " + username));
        return this.refreshTokenRepository.findByUserAndRevokedFalseAndExpiresAtAfter(user, Instant.now()).size();
    }

    private SessionInfoVO mapToSessionInfoVO(RefreshToken token) {
        String browser = this.deviceInfoService.getBrowser(token.getDeviceInfo());
        String os = this.deviceInfoService.getOperatingSystem(token.getDeviceInfo());
        return SessionInfoVO.builder().id(token.getId()).userId(token.getUser().getId().toString()).username(token.getUser().getUsername()).deviceInfo(token.getDeviceInfo()).browser(browser).operatingSystem(os).ipAddress(token.getIpAddress()).createdAt(token.getCreatedAt()).lastUsedAt(token.getLastUsedAt()).expiresAt(token.getExpiresAt()).current(false).build();
    }
}

