/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.VO.PortalUserSafeVO;
import com.cbmportal.portal.exceptions.DatabaseOperationException;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.PSRepository;
import com.cbmportal.portal.services.PSService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class PSServiceImpl
implements PSService {
    final Logger log = LoggerFactory.getLogger(PSServiceImpl.class);
    private final PSRepository psRepository;

    public PSServiceImpl(PSRepository psRepository) {
        this.psRepository = psRepository;
    }

    @Override
    public PS createPS(PS ps) {
        try {
            PS savedPS = (PS)this.psRepository.save(ps);
            PortalUserSafeVO safePortalUser = new PortalUserSafeVO(savedPS.getPortalUser().getId(), savedPS.getPortalUser().getUsername(), savedPS.getPortalUser().getUserFirst(), savedPS.getPortalUser().getUserLast(), savedPS.getPortalUser().getEmail());
            savedPS.setUserSafeVO(safePortalUser);
            return savedPS;
        }
        catch (DataAccessException dbExc) {
            this.log.error("Database error processing back pay form", (Throwable)dbExc);
            throw new DatabaseOperationException("Failed to save back pay data", dbExc);
        }
        catch (NullPointerException npe) {
            this.log.error("Null pointer error processing back pay form", (Throwable)npe);
            throw new FormProcessingException("Missing required data in back pay form", npe);
        }
    }

    @Override
    public Iterable<PS> getPS() {
        return this.psRepository.findAll();
    }

    @Override
    public PS updatePS(PS ps) {
        return (PS)this.psRepository.save(ps);
    }

    @Override
    public List<PS> findPSByPortalUser(long id) {
        ArrayList allList = new ArrayList();
        this.psRepository.findAll().iterator().forEachRemaining(allList::add);
        List<PS> filteredList = allList.stream().filter(ps -> ps.getPortalUser().getId() == id).toList();
        return filteredList;
    }
}

