/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Mileage;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.MileageRepository;
import com.cbmportal.portal.services.MileageService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.HtmlFragmentBuilder;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MileageServiceImpl
extends AbstractFormProcessingService<Mileage>
implements MileageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MileageServiceImpl.class);
    private final HtmlFragmentBuilder htmlBuilder;

    public MileageServiceImpl(MileageRepository mileageRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper, HtmlFragmentBuilder htmlBuilder) {
        super(pdfBuilderService, emailService, mileageRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.htmlBuilder = htmlBuilder;
    }

    @Override
    public FormSubmissionResponse processMileage(Mileage mileage) {
        return this.processForm(mileage);
    }

    @Override
    protected void validateFormData(Mileage mileage) {
        if (mileage == null) {
            throw new FormProcessingException("Mileage data cannot be null");
        }
        if (mileage.getEmployee() == null || mileage.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (mileage.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (mileage.getMileageDates() == null || mileage.getMileageDates().isEmpty()) {
            throw new FormProcessingException("At least one mileage entry is required");
        }
    }

    @Override
    protected FormContext buildFormContext(Mileage mileage) {
        String fullEmployeeName = mileage.getEmployee().getEmployeeFirst() + " " + mileage.getEmployee().getEmployeeLast();
        String empNum = mileage.getEmployee().getEmployeeNumber().toString();
        String payrollEmail = this.getDepartmentEmail("Payroll", "Mileage");
        return FormContext.builder().employee(mileage.getEmployee()).pdfFileName("Mileage-" + empNum + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation("mileage", empNum)).recipients(List.of(payrollEmail, mileage.getPortalUser().getEmail())).emailSubject("Mileage Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum)).portalUserName(mileage.getPortalUser().getUserFirst() + " " + mileage.getPortalUser().getUserLast()).comments(mileage.getComments()).formType("MILEAGE").build();
    }

    @Override
    protected Document generateHtmlDocument(FormContext context, Mileage mileage) throws IOException {
        File mileageHtml = new File(this.htmlFormLocation + "mileage.html");
        Document doc = Jsoup.parse((File)mileageHtml, (String)"UTF-8", (String)"");
        StringBuilder mileageInfo = new StringBuilder();
        for (MileageDate mileageItem : mileage.getMileageDates()) {
            String startLocation = mileageItem.getLocation1().getStoreNum() + " " + mileageItem.getLocation1().getName();
            String endLocation = mileageItem.getLocation2().getStoreNum() + " " + mileageItem.getLocation2().getName();
            mileageInfo.append(this.htmlBuilder.mileageRow(mileageItem.getDate(), startLocation, endLocation, this.dateFormatter));
        }
        doc.getElementsByClass("mileageInfo").html(mileageInfo.toString());
        doc.getElementsByClass("comments").html(this.htmlBuilder.valueOrDefault(context.getComments(), ""));
        doc.getElementsByClass("employeeNum").html(String.valueOf(context.getEmployee().getEmployeeNumber()));
        doc.getElementsByClass("employeeName").html(context.getEmployee().getEmployeeFirst() + " " + context.getEmployee().getEmployeeLast());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    @Override
    protected String getFormName() {
        return "Mileage Form";
    }

    @Override
    protected Long getEntityId(Mileage entity) {
        return entity.getId();
    }

    @Override
    protected void setSubmittedDate(Mileage mileage) {
        mileage.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber) {
        return this.htmlBuilder.simpleEmailBody("Mileage Form", employeeName, employeeNumber);
    }
}

