/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.HotelRepository;
import com.cbmportal.portal.services.HotelService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.DepartmentEmailHelper;
import com.cbmportal.portal.services.util.HtmlFragmentBuilder;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class HotelServiceImpl
implements HotelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HotelServiceImpl.class);
    private final HotelRepository hotelRepository;
    private final PdfBuilderService pdfBuilderService;
    private final CustomProperties customProperties;
    private final MicrosoftGraphEmailService emailService;
    private final String htmlFormLocation;
    private final PdfStorageHelper pdfStorageHelper;
    private final DepartmentEmailHelper emailHelper;
    private final HtmlFragmentBuilder htmlBuilder;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-yyyy");

    public HotelServiceImpl(HotelRepository hotelRepository, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, MicrosoftGraphEmailService emailService, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper, DepartmentEmailHelper emailHelper, HtmlFragmentBuilder htmlBuilder) {
        this.hotelRepository = hotelRepository;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.emailService = emailService;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
        this.emailHelper = emailHelper;
        this.htmlBuilder = htmlBuilder;
    }

    @Override
    public FormSubmissionResponse requestHotel(Hotel hotel, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        FormContext context = this.buildFormContext(hotel);
        try {
            Document doc = this.generateHtmlDocument(context, hotel);
            File pdfFile = new File(context.getPdfSaveLocation() + context.getPdfFileName());
            log.info("Generating PDF at: {}", (Object)pdfFile.getPath());
            this.pdfBuilderService.generatePdf(context.getPdfSaveLocation(), context.getPdfFileName(), doc);
            if (pdfFile.exists() && !pdfFile.isDirectory()) {
                log.info("{} was created successfully.", (Object)context.getPdfFileName());
                this.sendEmailNotification(context, pdfFile);
                response.setStatus(HttpStatus.OK.value());
                hotel.setSubmittedDate(LocalDateTime.now());
                Hotel savedHotel = (Hotel)this.hotelRepository.save(hotel);
                if (savedHotel.getId() != null) {
                    formResponse.setFormName("Hotel Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException exc) {
            log.error("Error processing hotel request", exc);
            formResponse.setFormName("Hotel Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(this.buildApiError((Exception)exc));
        }
        return formResponse;
    }

    private FormContext buildFormContext(Hotel hotel) throws IOException {
        String storeInfo = hotel.getStore().getStoreNum() + " " + hotel.getStore().getName();
        String financeEmail = this.emailHelper.getEmail("Finance", "Hotel");
        String base = this.customProperties.getPdfFiles();
        if (base == null || base.isBlank()) {
            throw new IOException("cbm.pdfFiles configuration is missing");
        }
        String pdfSaveLocation = this.pdfStorageHelper.buildAndPrepare(base, "hotel", hotel.getPortalUser().getUsername());
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        details.put("Location", storeInfo);
        details.put("Check-in", this.dateFormatter.format(hotel.getCheckIn()));
        details.put("Check-out", this.dateFormatter.format(hotel.getCheckOut()));
        details.put("Rooms", hotel.getNumOfRooms().toString());
        details.put("Beds", hotel.getNumOfBeds().toString());
        return FormContext.builder().pdfFileName("Hotel-" + hotel.getStore().getStoreNum() + "-" + hotel.getStore().getName() + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(pdfSaveLocation).recipients(List.of(financeEmail, hotel.getPortalUser().getEmail())).emailSubject("Hotel Request - " + storeInfo).emailBody(this.htmlBuilder.emailBody("Hotel Request", details)).storeName(hotel.getStore().getName()).storeNumber(hotel.getStore().getStoreNum()).portalUserName(hotel.getPortalUser().getUserFirst() + " " + hotel.getPortalUser().getUserLast()).comments(hotel.getComments() != null ? hotel.getComments() : "").formType("HOTEL").build();
    }

    private Document generateHtmlDocument(FormContext context, Hotel hotel) throws IOException {
        File hotelHtml = new File(this.htmlFormLocation + "hotel.html");
        Document doc = Jsoup.parse((File)hotelHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("location").html(context.getStoreNumber() + " " + context.getStoreName());
        doc.getElementsByClass("numOfRooms").html(hotel.getNumOfRooms().toString());
        doc.getElementsByClass("numOfBeds").html(hotel.getNumOfBeds().toString());
        doc.getElementsByClass("psInfo").html(this.generatePSInfo(hotel));
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("checkIn").html(this.dateFormatter.format(hotel.getCheckIn()));
        doc.getElementsByClass("checkOut").html(this.dateFormatter.format(hotel.getCheckOut()));
        doc.getElementsByClass("hotelReason").html(hotel.getHotelReason().getHotelReason());
        doc.getElementsByClass("workTicketNumber").html(this.htmlBuilder.valueOrDefault(hotel.getWorkTicket(), ""));
        doc.getElementsByClass("notes").html(this.htmlBuilder.valueOrDefault(context.getComments(), ""));
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    private void sendEmailNotification(FormContext context, File pdfFile) {
        this.emailService.sendEmail(context.getRecipients(), context.getEmailSubject(), context.getEmailBody(), pdfFile);
    }

    private ApiError buildApiError(Exception exc) {
        ApiError error = new ApiError();
        error.setApiName("/finance/hotelSubmit");
        error.setErrorMessage(exc.getMessage());
        error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        return error;
    }

    private String generatePSInfo(Hotel hotel) {
        StringBuilder ps = new StringBuilder();
        if (hotel.getNewPS() != null && !hotel.getNewPS().isEmpty()) {
            ps.append(this.htmlBuilder.div("newps-title", "New Employee Name"));
            ps.append(this.htmlBuilder.div("newps-info", hotel.getNewPS()));
        } else {
            ps.append(this.htmlBuilder.div("ps1-title", "Employee 1"));
            ps.append(this.htmlBuilder.div("ps1-info", (String)(hotel.getPs1() != null ? hotel.getPs1().getFirstName() + " " + hotel.getPs1().getLastName() : "")));
            ps.append(this.htmlBuilder.div("ps2-title", "Employee 2"));
            ps.append(this.htmlBuilder.div("ps2-info", (String)(hotel.getPs2() != null ? hotel.getPs2().getFirstName() + " " + hotel.getPs2().getLastName() : "")));
        }
        log.debug("Generated PS info: {}", (Object)ps);
        return ps.toString();
    }
}

