/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Bonus;
import com.cbmportal.portal.domains.BonusDate;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.BonusRepository;
import com.cbmportal.portal.services.BonusService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.HtmlFragmentBuilder;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BonusServiceImpl
extends AbstractFormProcessingService<Bonus>
implements BonusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BonusServiceImpl.class);
    private final HtmlFragmentBuilder htmlBuilder;

    public BonusServiceImpl(BonusRepository bonusRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper, HtmlFragmentBuilder htmlBuilder) {
        super(pdfBuilderService, emailService, bonusRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.htmlBuilder = htmlBuilder;
    }

    @Override
    public FormSubmissionResponse processBonus(Bonus bonus) {
        return this.processForm(bonus);
    }

    @Override
    protected void validateFormData(Bonus bonus) {
        if (bonus == null) {
            throw new FormProcessingException("Bonus data cannot be null");
        }
        if (bonus.getEmployee() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (bonus.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee number is required");
        }
        if (bonus.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (bonus.getBonuses() == null || bonus.getBonuses().isEmpty()) {
            throw new FormProcessingException("At least one bonus entry is required");
        }
    }

    @Override
    protected FormContext buildFormContext(Bonus bonus) {
        String fullEmployeeName = bonus.getEmployee().getEmployeeFirst() + " " + bonus.getEmployee().getEmployeeLast();
        String empNum = bonus.getEmployee().getEmployeeNumber().toString();
        String currentDate = this.dateFormatter.format(LocalDate.now());
        String payrollEmail = this.getDepartmentEmail("Payroll", "Bonus");
        return FormContext.builder().employee(bonus.getEmployee()).pdfFileName("Bonus-" + empNum + "-" + currentDate + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation("bonus", empNum)).recipients(List.of(payrollEmail, bonus.getPortalUser().getEmail())).emailSubject("Bonus Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum)).portalUserName(bonus.getPortalUser().getUserFirst() + " " + bonus.getPortalUser().getUserLast()).comments(bonus.getComments()).formType("BONUS").build();
    }

    @Override
    protected Document generateHtmlDocument(FormContext context, Bonus bonus) throws IOException {
        File bonusHtml = new File(this.htmlFormLocation + "bonus.html");
        Document doc = Jsoup.parse((File)bonusHtml, (String)"UTF-8", (String)"");
        StringBuilder bonusInfo = new StringBuilder();
        for (BonusDate bonusItem : bonus.getBonuses()) {
            String storeInfo = bonusItem.getStore().getStoreNum() + " " + bonusItem.getStore().getName();
            bonusInfo.append(this.htmlBuilder.bonusRow(bonusItem.getDate(), storeInfo, String.valueOf(bonusItem.getBonus()), this.dateFormatter));
        }
        doc.getElementsByClass("bonusInfo").html(bonusInfo.toString());
        doc.getElementsByClass("comments").html(this.htmlBuilder.valueOrDefault(context.getComments(), ""));
        doc.getElementsByClass("employeeNum").html(String.valueOf(context.getEmployee().getEmployeeNumber()));
        doc.getElementsByClass("employeeName").html(context.getEmployee().getEmployeeFirst() + " " + context.getEmployee().getEmployeeLast());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dmSig").html(this.htmlBuilder.signatureImage(bonus.getSig(), "Signature"));
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    @Override
    protected String getFormName() {
        return "Bonus Form";
    }

    @Override
    protected Long getEntityId(Bonus entity) {
        return entity.getId();
    }

    @Override
    protected void setSubmittedDate(Bonus bonus) {
        bonus.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber) {
        return this.htmlBuilder.simpleEmailBody("Bonus Form", employeeName, employeeNumber);
    }
}

