/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.TypeOfWork;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class WorkTicket {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="workTicket_id_seq")
    @SequenceGenerator(name="workTicket_id_seq", sequenceName="work_ticket_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @ManyToOne
    @JsonIgnoreProperties(value={"targetOrderList", "workTickets", "newHire", "bonuses"})
    private Store currentLocation;
    @JsonProperty
    @ManyToOne
    @JsonIgnoreProperties(value={"targetOrderList", "workTickets", "newHire", "bonuses"})
    private Store projectLocation;
    @JsonProperty
    @ManyToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee;
    @JsonProperty
    @ManyToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser;
    @JsonProperty
    private TypeOfWork typeOfWork;
    @JsonProperty
    private String isBillable;
    @JsonProperty
    private String notes;
    @JsonProperty
    private String equipmentNeeded;
    @JsonProperty
    private LocalDate supplyOrderDate;
    @JsonProperty
    private LocalDate projectStartDate;
    @JsonProperty
    private LocalDate projectEndDate;
    @JsonProperty
    private String orderNumber;
    @JsonProperty
    private Boolean supplyOrderSubmitted;
    @JsonProperty
    private LocalDateTime submittedDate = null;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkTicket that = (WorkTicket)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.currentLocation, that.currentLocation) && Objects.equals(this.projectLocation, that.projectLocation) && Objects.equals(this.employee, that.employee) && Objects.equals(this.portalUser, that.portalUser) && this.typeOfWork == that.typeOfWork && Objects.equals(this.isBillable, that.isBillable) && Objects.equals(this.notes, that.notes) && Objects.equals(this.equipmentNeeded, that.equipmentNeeded) && Objects.equals(this.supplyOrderDate, that.supplyOrderDate) && Objects.equals(this.projectStartDate, that.projectStartDate) && Objects.equals(this.projectEndDate, that.projectEndDate) && Objects.equals(this.orderNumber, that.orderNumber) && Objects.equals(this.supplyOrderSubmitted, that.supplyOrderSubmitted) && Objects.equals(this.apiError, that.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", WorkTicket.class.getSimpleName() + "[", "]").add("id=" + this.id).add("currentLocation=" + String.valueOf(this.currentLocation)).add("projectLocation=" + String.valueOf(this.projectLocation)).add("employee=" + String.valueOf(this.employee)).add("portalUser=" + String.valueOf(this.portalUser)).add("typeOfWork=" + String.valueOf((Object)this.typeOfWork)).add("isBillable='" + this.isBillable + "'").add("notes='" + this.notes + "'").add("equipmentNeeded='" + this.equipmentNeeded + "'").add("supplyOrderDate=" + String.valueOf(this.supplyOrderDate)).add("projectStartDate=" + String.valueOf(this.projectStartDate)).add("projectEndDate=" + String.valueOf(this.projectEndDate)).add("orderNumber='" + this.orderNumber + "'").add("supplyOrderSubmitted=" + this.supplyOrderSubmitted).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.currentLocation, this.projectLocation, this.employee, this.portalUser, this.typeOfWork, this.isBillable, this.notes, this.equipmentNeeded, this.supplyOrderDate, this.projectStartDate, this.projectEndDate, this.orderNumber, this.supplyOrderSubmitted, this.apiError});
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"targetOrderList", "workTickets", "newHire", "bonuses"})
    @Generated
    public void setCurrentLocation(Store currentLocation) {
        this.currentLocation = currentLocation;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"targetOrderList", "workTickets", "newHire", "bonuses"})
    @Generated
    public void setProjectLocation(Store projectLocation) {
        this.projectLocation = projectLocation;
    }

    @JsonProperty
    @Generated
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @Generated
    public void setTypeOfWork(TypeOfWork typeOfWork) {
        this.typeOfWork = typeOfWork;
    }

    @JsonProperty
    @Generated
    public void setIsBillable(String isBillable) {
        this.isBillable = isBillable;
    }

    @JsonProperty
    @Generated
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonProperty
    @Generated
    public void setEquipmentNeeded(String equipmentNeeded) {
        this.equipmentNeeded = equipmentNeeded;
    }

    @JsonProperty
    @Generated
    public void setSupplyOrderDate(LocalDate supplyOrderDate) {
        this.supplyOrderDate = supplyOrderDate;
    }

    @JsonProperty
    @Generated
    public void setProjectStartDate(LocalDate projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    @JsonProperty
    @Generated
    public void setProjectEndDate(LocalDate projectEndDate) {
        this.projectEndDate = projectEndDate;
    }

    @JsonProperty
    @Generated
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    @JsonProperty
    @Generated
    public void setSupplyOrderSubmitted(Boolean supplyOrderSubmitted) {
        this.supplyOrderSubmitted = supplyOrderSubmitted;
    }

    @JsonProperty
    @Generated
    public void setSubmittedDate(LocalDateTime submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Store getCurrentLocation() {
        return this.currentLocation;
    }

    @Generated
    public Store getProjectLocation() {
        return this.projectLocation;
    }

    @Generated
    public Employee getEmployee() {
        return this.employee;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public TypeOfWork getTypeOfWork() {
        return this.typeOfWork;
    }

    @Generated
    public String getIsBillable() {
        return this.isBillable;
    }

    @Generated
    public String getNotes() {
        return this.notes;
    }

    @Generated
    public String getEquipmentNeeded() {
        return this.equipmentNeeded;
    }

    @Generated
    public LocalDate getSupplyOrderDate() {
        return this.supplyOrderDate;
    }

    @Generated
    public LocalDate getProjectStartDate() {
        return this.projectStartDate;
    }

    @Generated
    public LocalDate getProjectEndDate() {
        return this.projectEndDate;
    }

    @Generated
    public String getOrderNumber() {
        return this.orderNumber;
    }

    @Generated
    public Boolean getSupplyOrderSubmitted() {
        return this.supplyOrderSubmitted;
    }

    @Generated
    public LocalDateTime getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

