/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.UserPermission;
import com.cbmportal.portal.domains.UserRole;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.WorkTicket;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true)
public class PortalUser
implements UserDetails {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="portalUser_id_seq")
    @SequenceGenerator(name="portalUser_id_seq", sequenceName="portal_user_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    private UserPermission permission;
    @JsonProperty(value="userName")
    @JsonAlias(value={"username"})
    @Column(unique=true)
    private String userName;
    @JsonProperty
    private String userFirst;
    @JsonProperty
    private String userLast;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    @JsonProperty
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="portal_user_authorities", joinColumns={@JoinColumn(name="portal_user_id")}, inverseJoinColumns={@JoinColumn(name="authorities_id")})
    private Set<UserRole> authorities;
    @JsonProperty
    private String email;
    @JsonIgnore
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<TargetOrder> targetOrder;
    @JsonIgnore
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<WorkTicket> workTickets;
    @JsonProperty
    @ManyToMany
    private List<District> district;
    @JsonProperty
    @Column(nullable=false)
    private Boolean disabled = false;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public PortalUser() {
        this.authorities = new HashSet<UserRole>();
    }

    public PortalUser(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public PortalUser(Long id, String userName, String password, Set<UserRole> authorities) {
        this.userName = userName;
        this.password = password;
        this.authorities = authorities;
    }

    public PortalUser(UserPermission permission, String userName, String userFirst, String userLast, String password, String email, List<District> district, ApiError apiError) {
        this.permission = permission;
        this.userName = userName;
        this.userFirst = userFirst;
        this.userLast = userLast;
        this.password = password;
        this.email = email;
        this.district = district;
        this.apiError = apiError;
    }

    public PortalUser(String username, String encodedPassword, Set<UserRole> authorities) {
        this.userName = username;
        this.password = encodedPassword;
        this.authorities = authorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortalUser that = (PortalUser)o;
        return Objects.equals(this.id, that.id) && this.permission == that.permission && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && this.district == that.district && Objects.equals(this.apiError, that.apiError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.permission, this.userName, this.password, this.district, this.apiError});
    }

    public String toString() {
        return new StringJoiner(", ", PortalUser.class.getSimpleName() + "[", "]").add("id=" + this.id).add("permission=" + String.valueOf((Object)this.permission)).add("userName='" + this.userName + "'").add("userFirst='" + this.userFirst + "'").add("userLast='" + this.userLast + "'").add("password='" + this.password + "'").add("email='" + this.email + "'").add("district=" + String.valueOf(this.district)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public Set<UserRole> getAuthorities() {
        return this.authorities;
    }

    public String getUsername() {
        return this.userName;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public UserPermission getPermission() {
        return this.permission;
    }

    @Generated
    public String getUserFirst() {
        return this.userFirst;
    }

    @Generated
    public String getUserLast() {
        return this.userLast;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public List<TargetOrder> getTargetOrder() {
        return this.targetOrder;
    }

    @Generated
    public List<WorkTicket> getWorkTickets() {
        return this.workTickets;
    }

    @Generated
    public List<District> getDistrict() {
        return this.district;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setPermission(UserPermission permission) {
        this.permission = permission;
    }

    @JsonProperty(value="userName")
    @JsonAlias(value={"username"})
    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty
    @Generated
    public void setUserFirst(String userFirst) {
        this.userFirst = userFirst;
    }

    @JsonProperty
    @Generated
    public void setUserLast(String userLast) {
        this.userLast = userLast;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty
    @Generated
    public void setAuthorities(Set<UserRole> authorities) {
        this.authorities = authorities;
    }

    @JsonProperty
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonIgnore
    @Generated
    public void setTargetOrder(List<TargetOrder> targetOrder) {
        this.targetOrder = targetOrder;
    }

    @JsonIgnore
    @Generated
    public void setWorkTickets(List<WorkTicket> workTickets) {
        this.workTickets = workTickets;
    }

    @JsonProperty
    @Generated
    public void setDistrict(List<District> district) {
        this.district = district;
    }

    @JsonProperty
    @Generated
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }
}

