/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.HotelReason;
import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;

@Entity
public class Hotel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="hotel_id_seq")
    @SequenceGenerator(name="hotel_id_seq", sequenceName="hotel_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser;
    @JsonProperty
    @OneToOne
    private Store store;
    @JsonProperty
    private LocalDate checkIn;
    @JsonProperty
    private LocalDate checkOut;
    @JsonProperty
    private Integer numOfRooms;
    @JsonProperty
    private Integer numOfBeds;
    @JsonProperty
    @OneToOne
    private PS ps1;
    @JsonProperty
    @OneToOne
    private PS ps2;
    @JsonProperty
    private String newPS;
    @JsonProperty
    private HotelReason hotelReason;
    @JsonProperty
    private String workTicket;
    @JsonProperty
    private String comments;
    @JsonProperty
    private LocalDateTime submittedDate = null;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public Hotel() {
    }

    public Hotel(PortalUser portalUser, Store store, LocalDate checkIn, LocalDate checkOut, Integer numOfRooms, Integer numOfBeds, PS ps1, PS ps2, String newPS, HotelReason hotelReason, String workTicket, String comments, ApiError apiError) {
        this.portalUser = portalUser;
        this.store = store;
        this.checkIn = checkIn;
        this.checkOut = checkOut;
        this.numOfRooms = numOfRooms;
        this.numOfBeds = numOfBeds;
        this.ps1 = ps1;
        this.ps2 = ps2;
        this.newPS = newPS;
        this.hotelReason = hotelReason;
        this.workTicket = workTicket;
        this.comments = comments;
        this.apiError = apiError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hotel hotel = (Hotel)o;
        return Objects.equals(this.id, hotel.id) && Objects.equals(this.portalUser, hotel.portalUser) && Objects.equals(this.store, hotel.store) && Objects.equals(this.checkIn, hotel.checkIn) && Objects.equals(this.checkOut, hotel.checkOut) && Objects.equals(this.numOfRooms, hotel.numOfRooms) && Objects.equals(this.numOfBeds, hotel.numOfBeds) && Objects.equals(this.ps1, hotel.ps1) && Objects.equals(this.ps2, hotel.ps2) && Objects.equals(this.newPS, hotel.newPS) && this.hotelReason == hotel.hotelReason && Objects.equals(this.workTicket, hotel.workTicket) && Objects.equals(this.comments, hotel.comments) && Objects.equals(this.apiError, hotel.apiError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.portalUser, this.store, this.checkIn, this.checkOut, this.numOfRooms, this.numOfBeds, this.ps1, this.ps2, this.newPS, this.hotelReason, this.workTicket, this.comments, this.apiError});
    }

    public String toString() {
        return new StringJoiner(", ", Hotel.class.getSimpleName() + "[", "]").add("id=" + this.id).add("portalUser=" + String.valueOf(this.portalUser)).add("store=" + String.valueOf(this.store)).add("checkIn=" + String.valueOf(this.checkIn)).add("checkOut=" + String.valueOf(this.checkOut)).add("numOfRooms=" + this.numOfRooms).add("numOfBeds=" + this.numOfBeds).add("ps1=" + String.valueOf(this.ps1)).add("ps2=" + String.valueOf(this.ps2)).add("newPS='" + this.newPS + "'").add("hotelReason=" + String.valueOf((Object)this.hotelReason)).add("workTicket='" + this.workTicket + "'").add("comments='" + this.comments + "'").add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @Generated
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    @Generated
    public void setCheckIn(LocalDate checkIn) {
        this.checkIn = checkIn;
    }

    @JsonProperty
    @Generated
    public void setCheckOut(LocalDate checkOut) {
        this.checkOut = checkOut;
    }

    @JsonProperty
    @Generated
    public void setNumOfRooms(Integer numOfRooms) {
        this.numOfRooms = numOfRooms;
    }

    @JsonProperty
    @Generated
    public void setNumOfBeds(Integer numOfBeds) {
        this.numOfBeds = numOfBeds;
    }

    @JsonProperty
    @Generated
    public void setPs1(PS ps1) {
        this.ps1 = ps1;
    }

    @JsonProperty
    @Generated
    public void setPs2(PS ps2) {
        this.ps2 = ps2;
    }

    @JsonProperty
    @Generated
    public void setNewPS(String newPS) {
        this.newPS = newPS;
    }

    @JsonProperty
    @Generated
    public void setHotelReason(HotelReason hotelReason) {
        this.hotelReason = hotelReason;
    }

    @JsonProperty
    @Generated
    public void setWorkTicket(String workTicket) {
        this.workTicket = workTicket;
    }

    @JsonProperty
    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    @Generated
    public void setSubmittedDate(LocalDateTime submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public Store getStore() {
        return this.store;
    }

    @Generated
    public LocalDate getCheckIn() {
        return this.checkIn;
    }

    @Generated
    public LocalDate getCheckOut() {
        return this.checkOut;
    }

    @Generated
    public Integer getNumOfRooms() {
        return this.numOfRooms;
    }

    @Generated
    public Integer getNumOfBeds() {
        return this.numOfBeds;
    }

    @Generated
    public PS getPs1() {
        return this.ps1;
    }

    @Generated
    public PS getPs2() {
        return this.ps2;
    }

    @Generated
    public String getNewPS() {
        return this.newPS;
    }

    @Generated
    public HotelReason getHotelReason() {
        return this.hotelReason;
    }

    @Generated
    public String getWorkTicket() {
        return this.workTicket;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public LocalDateTime getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

