/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.TargetItem;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.domains.VO.TargetItemWrapper;
import com.cbmportal.portal.services.PSService;
import com.cbmportal.portal.services.TargetItemService;
import com.cbmportal.portal.services.TargetOrderService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerErrorException;

@RestController
@RequestMapping(value={"/api/v1/ops"})
public class OperationsSubmissionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationsSubmissionController.class);
    private final TargetOrderService targetOrderService;
    private final PSService psService;
    private final TargetItemService targetItemService;

    public OperationsSubmissionController(TargetOrderService targetOrderService, PSService psService, TargetItemService targetItemService) {
        this.targetOrderService = targetOrderService;
        this.psService = psService;
        this.targetItemService = targetItemService;
    }

    @PostMapping(value={"/targetOrderSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitTargetOrder(@RequestBody TargetOrder targetOrder, HttpServletResponse response) throws IOException {
        log.info("Target order submission received for store: {}", (Object)(targetOrder.getStore() != null ? targetOrder.getStore().getStoreNum() : "unknown"));
        FormSubmissionResponse formResponse = this.targetOrderService.processTargetOrder(targetOrder, response);
        log.info("Target order processed successfully");
        return ResponseEntity.ok((Object)formResponse);
    }

    @GetMapping(value={"/getPSByPortalUserId/{portalUserId}"})
    public ResponseEntity<List<PS>> getPSByPortalUserId(@PathVariable long portalUserId) {
        log.debug("Fetching PS list for portal user ID: {}", (Object)portalUserId);
        List<PS> returnedPsList = this.psService.findPSByPortalUser(portalUserId);
        return ResponseEntity.ok(returnedPsList);
    }

    @GetMapping(value={"/getPS"})
    public ResponseEntity<List<PS>> getAllPS() {
        log.debug("Fetching all PS");
        ArrayList psList = new ArrayList();
        this.psService.getPS().iterator().forEachRemaining(psList::add);
        return ResponseEntity.ok(psList);
    }

    @PostMapping(value={"/createTargetItem"})
    public ResponseEntity<TargetItem> createTargetItem(@RequestBody TargetItem targetItem, HttpServletRequest request) {
        log.info("Creating target item: {}", (Object)targetItem.getItemName());
        TargetItem savedTargetItem = this.targetItemService.targetItemCreation(targetItem);
        if (savedTargetItem == null) {
            log.warn("Target item creation returned null");
            return ResponseEntity.ok().body(null);
        }
        log.info("Target item created successfully with ID: {}", (Object)savedTargetItem.getId());
        return ResponseEntity.ok((Object)savedTargetItem);
    }

    @GetMapping(value={"/getTargetItems"})
    public ResponseEntity<TargetItemWrapper> getTargetItems(HttpServletRequest request) {
        log.debug("Fetching all target items");
        TargetItemWrapper targetItemWrapper = new TargetItemWrapper();
        try {
            List<TargetItem> targetItems = this.targetItemService.getTargetItems();
            targetItemWrapper.setTargetItems(targetItems);
            if (targetItems.isEmpty()) {
                targetItemWrapper.setApiError(new ApiError(request.getRequestURI(), "No items were found."));
            }
            return ResponseEntity.ok((Object)targetItemWrapper);
        }
        catch (ServerErrorException sExc) {
            targetItemWrapper.setApiError(new ApiError(request.getRequestURI(), sExc.getMessage()));
            return ResponseEntity.status((HttpStatusCode)sExc.getStatusCode()).body((Object)targetItemWrapper);
        }
    }

    @GetMapping(value={"/getTargetItemsPaginated"})
    public ResponseEntity<Page<TargetItem>> getTargetItemsPaginated(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size, @RequestParam(defaultValue="itemName") String sortBy, @RequestParam(defaultValue="asc") String sortDirection) {
        log.info("Fetching paginated target items - page: {}, size: {}", (Object)page, (Object)size);
        Sort sort = sortDirection.equalsIgnoreCase("asc") ? Sort.by((String[])new String[]{sortBy}).ascending() : Sort.by((String[])new String[]{sortBy}).descending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        Page<TargetItem> targetItems = this.targetItemService.getTargetItemsPaginated((Pageable)pageable);
        log.info("Paginated target items retrieved - page {}/{}, total: {}", new Object[]{page + 1, targetItems.getTotalPages(), targetItems.getTotalElements()});
        return ResponseEntity.ok(targetItems);
    }
}

