/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl.admin;

import com.cbmportal.portal.domains.BackPay;
import com.cbmportal.portal.domains.Bonus;
import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.Mileage;
import com.cbmportal.portal.domains.NewHire;
import com.cbmportal.portal.domains.NonMnMileage;
import com.cbmportal.portal.domains.PerDiem;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Pto;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.Termination;
import com.cbmportal.portal.domains.TimeAdjustment;
import com.cbmportal.portal.domains.Uniform;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.repositories.BackpayRepository;
import com.cbmportal.portal.repositories.BonusRepository;
import com.cbmportal.portal.repositories.HotelRepository;
import com.cbmportal.portal.repositories.MileageRepository;
import com.cbmportal.portal.repositories.NewHireRepository;
import com.cbmportal.portal.repositories.NonMnMileageRepository;
import com.cbmportal.portal.repositories.PerDiemRepository;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.repositories.PtoRepository;
import com.cbmportal.portal.repositories.TargetOrderRepository;
import com.cbmportal.portal.repositories.TerminationRepository;
import com.cbmportal.portal.repositories.TimeAdjustmentRepository;
import com.cbmportal.portal.repositories.UniformRepository;
import com.cbmportal.portal.repositories.WorkTicketRepository;
import com.cbmportal.portal.services.admin.FormAdminService;
import com.cbmportal.portal.services.impl.admin.FormAdminServiceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class FormAdminServiceImpl
implements FormAdminService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FormAdminServiceImpl.class);
    private final BackpayRepository backpayRepository;
    private final BonusRepository bonusRepository;
    private final HotelRepository hotelRepository;
    private final MileageRepository mileageRepository;
    private final NewHireRepository newHireRepository;
    private final NonMnMileageRepository nonMnMileageRepository;
    private final PerDiemRepository perDiemRepository;
    private final PtoRepository ptoRepository;
    private final TargetOrderRepository targetOrderRepository;
    private final TerminationRepository terminationRepository;
    private final TimeAdjustmentRepository timeAdjustmentRepository;
    private final UniformRepository uniformRepository;
    private final WorkTicketRepository workTicketRepository;
    private final PortalUserRepository portalUserRepository;

    public FormAdminServiceImpl(BackpayRepository backpayRepository, BonusRepository bonusRepository, HotelRepository hotelRepository, MileageRepository mileageRepository, NewHireRepository newHireRepository, NonMnMileageRepository nonMnMileageRepository, PerDiemRepository perDiemRepository, PtoRepository ptoRepository, TargetOrderRepository targetOrderRepository, TerminationRepository terminationRepository, TimeAdjustmentRepository timeAdjustmentRepository, UniformRepository uniformRepository, WorkTicketRepository workTicketRepository, PortalUserRepository portalUserRepository) {
        this.backpayRepository = backpayRepository;
        this.bonusRepository = bonusRepository;
        this.hotelRepository = hotelRepository;
        this.mileageRepository = mileageRepository;
        this.newHireRepository = newHireRepository;
        this.nonMnMileageRepository = nonMnMileageRepository;
        this.perDiemRepository = perDiemRepository;
        this.ptoRepository = ptoRepository;
        this.targetOrderRepository = targetOrderRepository;
        this.terminationRepository = terminationRepository;
        this.timeAdjustmentRepository = timeAdjustmentRepository;
        this.uniformRepository = uniformRepository;
        this.workTicketRepository = workTicketRepository;
        this.portalUserRepository = portalUserRepository;
    }

    private Authentication auth() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private boolean isAdminOrOffice() {
        Authentication a = this.auth();
        if (a == null) {
            return false;
        }
        Set roles = a.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        return roles.contains("Admin") || roles.contains("Office");
    }

    private boolean isDM() {
        Authentication a = this.auth();
        if (a == null) {
            return false;
        }
        return a.getAuthorities().stream().anyMatch(ga -> "DM".equals(ga.getAuthority()));
    }

    private Long currentUserId() {
        Authentication a = this.auth();
        if (a == null) {
            return null;
        }
        String username = a.getName();
        return this.portalUserRepository.findByUserNameAndDisabledFalse(username).map(PortalUser::getId).orElse(null);
    }

    private Set<Long> currentUserDistrictIds() {
        Authentication a = this.auth();
        if (a == null) {
            return Collections.emptySet();
        }
        String username = a.getName();
        return this.portalUserRepository.findByUserNameAndDisabledFalse(username).map(u -> u.getDistrict() == null ? Collections.emptySet() : u.getDistrict().stream().map(District::getId).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    private boolean inDistrict(Store store, Set<Long> allowedDistrictIds) {
        if (store == null || store.getDistrict() == null || store.getDistrict().getId() == null) {
            return false;
        }
        return allowedDistrictIds.contains(store.getDistrict().getId());
    }

    private <T> List<T> getFilteredSubmissions(Iterable<T> allEntities, PortalUserExtractor<T> portalUserExtractor, DistrictChecker<T> districtChecker) {
        List all = StreamSupport.stream(allEntities.spliterator(), false).collect(Collectors.toList());
        if (this.isAdminOrOffice()) {
            return all;
        }
        Long uid = this.currentUserId();
        Set districtIds = this.isDM() ? this.currentUserDistrictIds() : Collections.emptySet();
        return all.stream().filter(entity -> {
            PortalUser pu = portalUserExtractor.extract(entity);
            boolean isOwner = pu != null && pu.getId().equals(uid);
            boolean inUserDistrict = this.isDM() && districtChecker != null && districtChecker.check(entity, districtIds);
            return isOwner || inUserDistrict;
        }).collect(Collectors.toList());
    }

    private <E> Page<E> paginate(List<E> items, Pageable pageable) {
        int total = items.size();
        int start = (int)Math.min(pageable.getOffset(), (long)total);
        int end = Math.min(start + pageable.getPageSize(), total);
        List<E> content = items.subList(start, end);
        return new PageImpl(content, pageable, (long)total);
    }

    private <T> Page<T> getPaginatedSubmissions(JpaRepository<T, Long> repository, Pageable pageable, Supplier<List<T>> filteredSupplier) {
        if (this.isAdminOrOffice()) {
            return repository.findAll(pageable);
        }
        return this.paginate(filteredSupplier.get(), pageable);
    }

    public List<BackPay> getBackPaySubmissions() {
        return this.getFilteredSubmissions((Iterable)this.backpayRepository.findAll(), BackPay::getPortalUser, (bp, districts) -> this.inDistrict(bp.getStore(), districts));
    }

    public List<Bonus> getBonusSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.bonusRepository.findAll(), Bonus::getPortalUser, (b, districts) -> b.getBonuses() != null && b.getBonuses().stream().anyMatch(bd -> this.inDistrict(bd.getStore(), districts)));
    }

    public List<Hotel> getHotelSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.hotelRepository.findAll(), Hotel::getPortalUser, (h, districts) -> this.inDistrict(h.getStore(), districts));
    }

    public List<Mileage> getMileageSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.mileageRepository.findAll(), Mileage::getPortalUser, (m, districts) -> m.getMileageDates() != null && m.getMileageDates().stream().anyMatch(md -> this.inDistrict(md.getLocation1(), districts) || this.inDistrict(md.getLocation2(), districts)));
    }

    public List<NewHire> getNewHireSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.newHireRepository.findAll(), NewHire::getPortalUser, (n, districts) -> this.inDistrict(n.getStore(), districts));
    }

    public List<NonMnMileage> getNonMnMileageSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.nonMnMileageRepository.findAll(), NonMnMileage::getPortalUser, (m, districts) -> m.getMileageDates() != null && m.getMileageDates().stream().anyMatch(md -> this.inDistrict(md.getLocation1(), districts) || this.inDistrict(md.getLocation2(), districts)));
    }

    public List<PerDiem> getPerDiemSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.perDiemRepository.findAll(), PerDiem::getPortalUser, (p, districts) -> this.inDistrict(p.getStore(), districts));
    }

    public List<Pto> getPtoSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.ptoRepository.findAll(), Pto::getPortalUser, null);
    }

    public List<TargetOrder> getTargetOrderSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.targetOrderRepository.findAll(), TargetOrder::getPortalUser, (t, districts) -> this.inDistrict(t.getStore(), districts));
    }

    public List<Termination> getTerminationSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.terminationRepository.findAll(), Termination::getPortalUser, null);
    }

    public List<TimeAdjustment> getTimeAdjustmentSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.timeAdjustmentRepository.findAll(), TimeAdjustment::getPortalUser, null);
    }

    public List<Uniform> getUniformSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.uniformRepository.findAll(), Uniform::getPortalUser, null);
    }

    public List<WorkTicket> getWorkTicketSubmissions() {
        return this.getFilteredSubmissions((Iterable)this.workTicketRepository.findAll(), WorkTicket::getPortalUser, (w, districts) -> this.inDistrict(w.getCurrentLocation(), districts) || this.inDistrict(w.getProjectLocation(), districts));
    }

    public Page<BackPay> getBackPaySubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.backpayRepository, pageable, () -> this.getBackPaySubmissions());
    }

    public Page<Bonus> getBonusSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.bonusRepository, pageable, () -> this.getBonusSubmissions());
    }

    public Page<Hotel> getHotelSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.hotelRepository, pageable, () -> this.getHotelSubmissions());
    }

    public Page<Mileage> getMileageSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.mileageRepository, pageable, () -> this.getMileageSubmissions());
    }

    public Page<NewHire> getNewHireSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.newHireRepository, pageable, () -> this.getNewHireSubmissions());
    }

    public Page<NonMnMileage> getNonMnMileageSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.nonMnMileageRepository, pageable, () -> this.getNonMnMileageSubmissions());
    }

    public Page<PerDiem> getPerDiemSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.perDiemRepository, pageable, () -> this.getPerDiemSubmissions());
    }

    public Page<Pto> getPtoSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.ptoRepository, pageable, () -> this.getPtoSubmissions());
    }

    public Page<TargetOrder> getTargetOrderSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.targetOrderRepository, pageable, () -> this.getTargetOrderSubmissions());
    }

    public Page<Termination> getTerminationSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.terminationRepository, pageable, () -> this.getTerminationSubmissions());
    }

    public Page<TimeAdjustment> getTimeAdjustmentSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.timeAdjustmentRepository, pageable, () -> this.getTimeAdjustmentSubmissions());
    }

    public Page<Uniform> getUniformSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.uniformRepository, pageable, () -> this.getUniformSubmissions());
    }

    public Page<WorkTicket> getWorkTicketSubmissionsPaginated(Pageable pageable) {
        return this.getPaginatedSubmissions((JpaRepository)this.workTicketRepository, pageable, () -> this.getWorkTicketSubmissions());
    }

    public List<BackPay> getBackPaySubmissionsByUser(Long userId) {
        return this.backpayRepository.findByPortalUserId(userId);
    }

    public List<Bonus> getBonusSubmissionsByUser(Long userId) {
        return this.bonusRepository.findByPortalUserId(userId);
    }

    public List<Hotel> getHotelSubmissionsByUser(Long userId) {
        return this.hotelRepository.findAllByPortalUserId(userId);
    }

    public List<Mileage> getMileageSubmissionsByUser(Long userId) {
        return this.mileageRepository.findByPortalUserId(userId);
    }

    public List<NewHire> getNewHireSubmissionsByUser(Long userId) {
        return this.newHireRepository.findAllByPortalUserId(userId);
    }

    public List<NonMnMileage> getNonMnMileageSubmissionsByUser(Long userId) {
        return this.nonMnMileageRepository.findByPortalUserId(userId);
    }

    public List<PerDiem> getPerDiemSubmissionsByUser(Long userId) {
        return this.perDiemRepository.findByPortalUserId(userId);
    }

    public List<Pto> getPtoSubmissionsByUser(Long userId) {
        return this.ptoRepository.findByPortalUserId(userId);
    }

    public List<TargetOrder> getTargetOrderSubmissionsByUser(Long userId) {
        return this.targetOrderRepository.findByPortalUserId(userId);
    }

    public List<Termination> getTerminationSubmissionsByUser(Long userId) {
        return this.terminationRepository.findAllByPortalUserId(userId);
    }

    public List<TimeAdjustment> getTimeAdjustmentSubmissionsByUser(Long userId) {
        return this.timeAdjustmentRepository.findAllByPortalUserId(userId);
    }

    public List<Uniform> getUniformSubmissionsByUser(Long userId) {
        return this.uniformRepository.findByPortalUserId(userId);
    }

    public List<WorkTicket> getWorkTicketSubmissionsByUser(Long userId) {
        return this.workTicketRepository.findAllByPortalUserId(userId);
    }

    public long countBackPaySubmissions() {
        return this.isAdminOrOffice() ? this.backpayRepository.count() : (long)this.getBackPaySubmissions().size();
    }

    public long countBonusSubmissions() {
        return this.isAdminOrOffice() ? this.bonusRepository.count() : (long)this.getBonusSubmissions().size();
    }

    public long countHotelSubmissions() {
        return this.isAdminOrOffice() ? this.hotelRepository.count() : (long)this.getHotelSubmissions().size();
    }

    public long countMileageSubmissions() {
        return this.isAdminOrOffice() ? this.mileageRepository.count() : (long)this.getMileageSubmissions().size();
    }

    public long countNewHireSubmissions() {
        return this.isAdminOrOffice() ? this.newHireRepository.count() : (long)this.getNewHireSubmissions().size();
    }

    public long countNonMnMileageSubmissions() {
        return this.isAdminOrOffice() ? this.nonMnMileageRepository.count() : (long)this.getNonMnMileageSubmissions().size();
    }

    public long countPerDiemSubmissions() {
        return this.isAdminOrOffice() ? this.perDiemRepository.count() : (long)this.getPerDiemSubmissions().size();
    }

    public long countPtoSubmissions() {
        return this.isAdminOrOffice() ? this.ptoRepository.count() : (long)this.getPtoSubmissions().size();
    }

    public long countTargetOrderSubmissions() {
        return this.isAdminOrOffice() ? this.targetOrderRepository.count() : (long)this.getTargetOrderSubmissions().size();
    }

    public long countTerminationSubmissions() {
        return this.isAdminOrOffice() ? this.terminationRepository.count() : (long)this.getTerminationSubmissions().size();
    }

    public long countUniformSubmissions() {
        return this.isAdminOrOffice() ? this.uniformRepository.count() : (long)this.getUniformSubmissions().size();
    }

    public long countWorkTicketSubmissions() {
        return this.isAdminOrOffice() ? this.workTicketRepository.count() : (long)this.getWorkTicketSubmissions().size();
    }
}

