/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.microsoft.graph.models.BodyType;
import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.FileAttachment;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.graph.users.item.sendmail.SendMailPostRequestBody;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class MicrosoftGraphEmailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicrosoftGraphEmailService.class);
    private final GraphServiceClient graphClient;
    private final String senderEmail;
    private final Environment environment;

    public MicrosoftGraphEmailService(@Value(value="${microsoft.graph.tenant-id}") String tenantId, @Value(value="${microsoft.graph.client-id}") String clientId, @Value(value="${microsoft.graph.client-secret}") String clientSecret, @Value(value="${microsoft.graph.sender-email}") String senderEmail, Environment environment) {
        log.info("Initializing Microsoft Graph Email Service...");
        this.validateConfiguration(tenantId, clientId, clientSecret, senderEmail);
        log.info("Microsoft Graph configuration validated. Sender: {}", (Object)senderEmail);
        try {
            ClientSecretCredential credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(clientSecret).tenantId(tenantId)).build();
            this.graphClient = new GraphServiceClient((TokenCredential)credential, new String[0]);
            this.senderEmail = senderEmail;
            this.environment = environment;
            log.info("Microsoft Graph Email Service initialized successfully");
        }
        catch (Exception e) {
            log.error("Failed to initialize Microsoft Graph Email Service", (Throwable)e);
            throw new IllegalStateException("Failed to initialize Microsoft Graph Email Service: " + e.getMessage(), e);
        }
    }

    private void validateConfiguration(String tenantId, String clientId, String clientSecret, String senderEmail) {
        if (tenantId == null || tenantId.trim().isEmpty() || tenantId.startsWith("${")) {
            String error = "Microsoft Graph tenant-id is not configured. Please set MICROSOFT_TENANT_ID environment variable.";
            log.error(error);
            throw new IllegalStateException(error);
        }
        if (clientId == null || clientId.trim().isEmpty() || clientId.startsWith("${")) {
            String error = "Microsoft Graph client-id is not configured. Please set MICROSOFT_CLIENT_ID environment variable.";
            log.error(error);
            throw new IllegalStateException(error);
        }
        if (clientSecret == null || clientSecret.trim().isEmpty() || clientSecret.startsWith("${")) {
            String error = "Microsoft Graph client-secret is not configured. Please set MICROSOFT_CLIENT_SECRET environment variable.";
            log.error(error);
            throw new IllegalStateException(error);
        }
        if (senderEmail == null || senderEmail.trim().isEmpty() || senderEmail.startsWith("${")) {
            String error = "Microsoft Graph sender-email is not configured. Please set sender-email in application properties.";
            log.error(error);
            throw new IllegalStateException(error);
        }
        log.debug("Microsoft Graph configuration validation passed");
    }

    public void sendEmail(String recipient, String subject, String htmlBody) {
        this.sendEmail(List.of(recipient), subject, htmlBody, (List)null);
    }

    public void sendEmail(List<String> recipients, String subject, String htmlBody) {
        this.sendEmail(recipients, subject, htmlBody, (List)null);
    }

    public void sendEmail(String recipient, String subject, String htmlBody, File pdfAttachment) {
        this.sendEmail(List.of(recipient), subject, htmlBody, pdfAttachment);
    }

    public void sendEmail(List<String> recipients, String subject, String htmlBody, File pdfAttachment) {
        this.sendEmail(recipients, subject, htmlBody, pdfAttachment != null ? List.of(pdfAttachment) : null);
    }

    public void sendEmail(List<String> recipients, String subject, String htmlBody, List<File> attachments) {
        if (List.of(this.environment.getActiveProfiles()).contains("test")) {
            log.info("[TEST PROFILE] Skipping actual Graph email send to {} with subject '{}'", recipients, (Object)subject);
            return;
        }
        try {
            log.info("Sending email to {} recipient(s) with subject: '{}'", (Object)recipients.size(), (Object)subject);
            Message message = new Message();
            Recipient sender = new Recipient();
            ArrayList<1> bccSender = new ArrayList<1>();
            EmailAddress senderEmailAddress = new EmailAddress();
            EmailAddress bccEmailAddress = new EmailAddress();
            senderEmailAddress.setName("CBM Portal Notification");
            senderEmailAddress.setAddress(this.senderEmail);
            bccEmailAddress.setAddress("joseph.schaeppi@carlsonbuilding.com");
            sender.setEmailAddress(senderEmailAddress);
            bccSender.add(new /* Unavailable Anonymous Inner Class!! */);
            message.setFrom(sender);
            message.setSubject(subject);
            ItemBody body = new ItemBody();
            body.setContentType(BodyType.Html);
            body.setContent(htmlBody);
            message.setBody(body);
            List toRecipients = recipients.stream().map(email -> {
                Recipient recipient = new Recipient();
                EmailAddress emailAddress = new EmailAddress();
                emailAddress.setAddress(email);
                recipient.setEmailAddress(emailAddress);
                return recipient;
            }).collect(Collectors.toList());
            message.setToRecipients(toRecipients);
            message.setCcRecipients(bccSender);
            if (attachments != null && !attachments.isEmpty()) {
                log.info("Adding {} attachment(s)", (Object)attachments.size());
                LinkedList<FileAttachment> fileAttachments = new LinkedList<FileAttachment>();
                for (File file : attachments) {
                    if (file == null || !file.exists()) continue;
                    FileAttachment attachment = this.createFileAttachment(file);
                    fileAttachments.add(attachment);
                }
                if (!fileAttachments.isEmpty()) {
                    message.setAttachments(new LinkedList(fileAttachments));
                }
            }
            SendMailPostRequestBody requestBody = new SendMailPostRequestBody();
            requestBody.setMessage(message);
            requestBody.setSaveToSentItems(Boolean.valueOf(true));
            this.graphClient.users().byUserId(this.senderEmail).sendMail().post(requestBody);
            log.info("Email sent successfully via Microsoft Graph API with {} attachment(s)", (Object)(attachments != null ? attachments.size() : 0));
        }
        catch (Exception e) {
            log.error("Failed to send email via Microsoft Graph API to recipients: {}", recipients, (Object)e);
            throw new RuntimeException("Failed to send email: " + e.getMessage(), e);
        }
    }

    private FileAttachment createFileAttachment(File file) throws IOException {
        byte[] fileBytes = Files.readAllBytes(file.toPath());
        FileAttachment attachment = new FileAttachment();
        attachment.setOdataType("#microsoft.graph.fileAttachment");
        attachment.setName(file.getName());
        attachment.setContentType(this.getContentType(file.getName()));
        attachment.setContentBytes(fileBytes);
        log.debug("Created attachment: {} (size: {} bytes, type: {})", new Object[]{file.getName(), fileBytes.length, attachment.getContentType()});
        return attachment;
    }

    private String getContentType(String fileName) {
        String lowerCaseName = fileName.toLowerCase();
        if (lowerCaseName.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (lowerCaseName.endsWith(".png")) {
            return "image/png";
        }
        if (lowerCaseName.endsWith(".jpg") || lowerCaseName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (lowerCaseName.endsWith(".gif")) {
            return "image/gif";
        }
        return "application/octet-stream";
    }
}

