/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.TargetOrderItem;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class TargetOrder {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="targetOrder_id_seq")
    @SequenceGenerator(name="targetOrder_id_seq", sequenceName="target_order_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser;
    @JsonProperty
    @ManyToOne
    @JsonIgnoreProperties(value={"targetOrderList", "workTickets", "newHire", "bonuses"})
    private Store store;
    @JsonProperty
    private String comments;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<TargetOrderItem> targetOrderItems;
    @JsonProperty
    private LocalDateTime submittedDate = null;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetOrder that = (TargetOrder)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.portalUser, that.portalUser) && Objects.equals(this.store, that.store) && Objects.equals(this.comments, that.comments) && Objects.equals(this.targetOrderItems, that.targetOrderItems) && Objects.equals(this.apiError, that.apiError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.portalUser, this.store, this.comments, this.targetOrderItems, this.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", TargetOrder.class.getSimpleName() + "[", "]").add("id=" + this.id).add("portalUser=" + String.valueOf(this.portalUser)).add("store=" + String.valueOf(this.store)).add("comments='" + this.comments + "'").add("targetOrderItems=" + String.valueOf(this.targetOrderItems)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"targetOrderList", "workTickets", "newHire", "bonuses"})
    @Generated
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    @Generated
    public void setTargetOrderItems(List<TargetOrderItem> targetOrderItems) {
        this.targetOrderItems = targetOrderItems;
    }

    @JsonProperty
    @Generated
    public void setSubmittedDate(LocalDateTime submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public Store getStore() {
        return this.store;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public List<TargetOrderItem> getTargetOrderItems() {
        return this.targetOrderItems;
    }

    @Generated
    public LocalDateTime getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

