/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Position;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class NewHire {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="newHire_id_seq")
    @SequenceGenerator(name="newHire_id_seq", sequenceName="new_hire_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser;
    @JsonProperty
    @OneToOne
    private Store store;
    @JsonProperty
    private String hireType;
    @JsonProperty
    private Integer numWorkDays;
    @JsonProperty
    private Double payRate;
    @JsonProperty
    private String numOfHours;
    @JsonProperty
    private String preferredLanguage;
    @JsonProperty
    private String comments;
    @JsonProperty
    private Position position;
    @JsonProperty
    @Transient
    private String positionNum = "";
    @JsonProperty
    private LocalDate firstDayWorked;
    @JsonProperty
    private String documentTitle;
    @JsonProperty
    private String documentNumber;
    @JsonProperty
    private String aNumber;
    @JsonProperty
    private LocalDate documentExp;
    @JsonProperty
    private LocalDateTime submittedDate = null;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewHire newHire = (NewHire)o;
        return Objects.equals(this.id, newHire.id) && Objects.equals(this.employee, newHire.employee) && Objects.equals(this.portalUser, newHire.portalUser) && Objects.equals(this.store, newHire.store) && Objects.equals(this.hireType, newHire.hireType) && Objects.equals(this.numWorkDays, newHire.numWorkDays) && Objects.equals(this.payRate, newHire.payRate) && Objects.equals(this.numOfHours, newHire.numOfHours) && Objects.equals(this.preferredLanguage, newHire.preferredLanguage) && Objects.equals(this.comments, newHire.comments) && this.position == newHire.position && Objects.equals(this.positionNum, newHire.positionNum) && Objects.equals(this.firstDayWorked, newHire.firstDayWorked) && Objects.equals(this.documentTitle, newHire.documentTitle) && Objects.equals(this.documentNumber, newHire.documentNumber) && Objects.equals(this.aNumber, newHire.aNumber) && Objects.equals(this.documentExp, newHire.documentExp) && Objects.equals(this.apiError, newHire.apiError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employee, this.portalUser, this.store, this.hireType, this.numWorkDays, this.payRate, this.numOfHours, this.preferredLanguage, this.comments, this.position, this.positionNum, this.firstDayWorked, this.documentTitle, this.documentNumber, this.aNumber, this.documentExp, this.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", NewHire.class.getSimpleName() + "[", "]").add("id=" + this.id).add("employee=" + String.valueOf(this.employee)).add("portalUser=" + String.valueOf(this.portalUser)).add("store=" + String.valueOf(this.store)).add("hireType='" + this.hireType + "'").add("numWorkDays=" + this.numWorkDays).add("payRate=" + this.payRate).add("numOfHours='" + this.numOfHours + "'").add("preferredLanguage='" + this.preferredLanguage + "'").add("comments='" + this.comments + "'").add("position=" + String.valueOf(this.position)).add("positionNum='" + this.positionNum + "'").add("firstDayWorked=" + String.valueOf(this.firstDayWorked)).add("documentTitle='" + this.documentTitle + "'").add("documentNumber='" + this.documentNumber + "'").add("aNumber='" + this.aNumber + "'").add("documentExp=" + String.valueOf(this.documentExp)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @Generated
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    @Generated
    public void setHireType(String hireType) {
        this.hireType = hireType;
    }

    @JsonProperty
    @Generated
    public void setNumWorkDays(Integer numWorkDays) {
        this.numWorkDays = numWorkDays;
    }

    @JsonProperty
    @Generated
    public void setPayRate(Double payRate) {
        this.payRate = payRate;
    }

    @JsonProperty
    @Generated
    public void setNumOfHours(String numOfHours) {
        this.numOfHours = numOfHours;
    }

    @JsonProperty
    @Generated
    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    @JsonProperty
    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    @Generated
    public void setPosition(Position position) {
        this.position = position;
    }

    @JsonProperty
    @Generated
    public void setPositionNum(String positionNum) {
        this.positionNum = positionNum;
    }

    @JsonProperty
    @Generated
    public void setFirstDayWorked(LocalDate firstDayWorked) {
        this.firstDayWorked = firstDayWorked;
    }

    @JsonProperty
    @Generated
    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    @JsonProperty
    @Generated
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @JsonProperty
    @Generated
    public void setANumber(String aNumber) {
        this.aNumber = aNumber;
    }

    @JsonProperty
    @Generated
    public void setDocumentExp(LocalDate documentExp) {
        this.documentExp = documentExp;
    }

    @JsonProperty
    @Generated
    public void setSubmittedDate(LocalDateTime submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Employee getEmployee() {
        return this.employee;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public Store getStore() {
        return this.store;
    }

    @Generated
    public String getHireType() {
        return this.hireType;
    }

    @Generated
    public Integer getNumWorkDays() {
        return this.numWorkDays;
    }

    @Generated
    public Double getPayRate() {
        return this.payRate;
    }

    @Generated
    public String getNumOfHours() {
        return this.numOfHours;
    }

    @Generated
    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public Position getPosition() {
        return this.position;
    }

    @Generated
    public String getPositionNum() {
        return this.positionNum;
    }

    @Generated
    public LocalDate getFirstDayWorked() {
        return this.firstDayWorked;
    }

    @Generated
    public String getDocumentTitle() {
        return this.documentTitle;
    }

    @Generated
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Generated
    public String getANumber() {
        return this.aNumber;
    }

    @Generated
    public LocalDate getDocumentExp() {
        return this.documentExp;
    }

    @Generated
    public LocalDateTime getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

