/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.exceptions.ResourceNotFoundException;
import com.cbmportal.portal.repositories.StoreRepository;
import com.cbmportal.portal.services.StoreService;
import org.springframework.stereotype.Service;

@Service
public class StoreServiceImpl
implements StoreService {
    private final StoreRepository storeRepository;

    public StoreServiceImpl(StoreRepository storeRepository) {
        this.storeRepository = storeRepository;
    }

    public Iterable<Store> getStores() {
        return this.storeRepository.findByDisabledFalse();
    }

    public Store getStoreById(Long id) {
        return this.storeRepository.findById((Object)id).filter(store -> !Boolean.TRUE.equals(store.getDisabled())).orElse(null);
    }

    public Iterable<Store> getStoresByDistrict(District district) {
        return this.storeRepository.findStoresByDistrictAndDisabledFalse(district);
    }

    public Store createDistrictStore(Store store) {
        return (Store)this.storeRepository.save((Object)store);
    }

    public Store updateStore(Store store) {
        return (Store)this.storeRepository.save((Object)store);
    }

    public Store disableStore(Long storeId) {
        Store store = (Store)this.storeRepository.findById((Object)storeId).orElseThrow(() -> new ResourceNotFoundException("Store", "id", (Object)storeId.toString()));
        store.setDisabled(Boolean.valueOf(true));
        return (Store)this.storeRepository.save((Object)store);
    }
}

