/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.BonusDate;
import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Bonus {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bonus_id_seq")
    @SequenceGenerator(name="bonus_id_seq", sequenceName="bonus_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<BonusDate> bonuses;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser;
    @JsonProperty
    private String comments;
    @JsonProperty
    private String sig;
    @JsonProperty
    private LocalDateTime submittedDate = null;
    @Transient
    @JsonProperty
    private ApiError apiError;

    public Bonus() {
    }

    public Bonus(List<BonusDate> bonuses, Employee employee, PortalUser portalUser, String comments, String sig, ApiError apiError) {
        this.bonuses = bonuses;
        this.employee = employee;
        this.portalUser = portalUser;
        this.comments = comments;
        this.sig = sig;
        this.apiError = apiError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bonus bonus = (Bonus)o;
        return Objects.equals(this.id, bonus.id) && Objects.equals(this.bonuses, bonus.bonuses) && Objects.equals(this.employee, bonus.employee) && Objects.equals(this.portalUser, bonus.portalUser) && Objects.equals(this.comments, bonus.comments) && Objects.equals(this.sig, bonus.sig) && Objects.equals(this.apiError, bonus.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", Bonus.class.getSimpleName() + "[", "]").add("id=" + this.id).add("bonuses=" + String.valueOf(this.bonuses)).add("employee=" + String.valueOf(this.employee)).add("portalUser=" + String.valueOf(this.portalUser)).add("comments='" + this.comments + "'").add("sig='" + this.sig + "'").add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.bonuses, this.employee, this.portalUser, this.comments, this.sig, this.apiError);
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setBonuses(List<BonusDate> bonuses) {
        this.bonuses = bonuses;
    }

    @JsonProperty
    @Generated
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    @Generated
    public void setSig(String sig) {
        this.sig = sig;
    }

    @JsonProperty
    @Generated
    public void setSubmittedDate(LocalDateTime submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public List<BonusDate> getBonuses() {
        return this.bonuses;
    }

    @Generated
    public Employee getEmployee() {
        return this.employee;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public String getSig() {
        return this.sig;
    }

    @Generated
    public LocalDateTime getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

