/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.RefreshToken;
import com.cbmportal.portal.services.SecurityNotificationService;
import com.cbmportal.portal.services.impl.DeviceInfoService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SecurityNotificationServiceImpl
implements SecurityNotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityNotificationServiceImpl.class);
    private final MicrosoftGraphEmailService emailService;
    private final DeviceInfoService deviceInfoService;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("MMM dd, yyyy 'at' hh:mm a");

    public SecurityNotificationServiceImpl(MicrosoftGraphEmailService emailService, DeviceInfoService deviceInfoService) {
        this.emailService = emailService;
        this.deviceInfoService = deviceInfoService;
    }

    public void notifyNewDeviceLogin(PortalUser user, RefreshToken refreshToken) {
        if (user == null || !StringUtils.hasText((String)user.getEmail())) {
            log.warn("Skipping new device login notification - user email is null/empty for user id {}", (Object)(user != null ? user.getId() : null));
            return;
        }
        log.info("Sending new device login notification to: {}", (Object)user.getEmail());
        String browser = this.deviceInfoService.getBrowser(refreshToken.getDeviceInfo());
        String os = this.deviceInfoService.getOperatingSystem(refreshToken.getDeviceInfo());
        String deviceDescription = browser + " on " + os;
        String subject = "New Device Login - CBM Portal";
        String htmlBody = this.buildEmailTemplate("New Device Login Detected", user.getUserFirst(), "We noticed a login to your CBM Portal account from a new device.", List.of("Device: " + deviceDescription, "IP Address: " + refreshToken.getIpAddress(), "Time: " + refreshToken.getCreatedAt().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER), "Location: " + (refreshToken.getIpAddress() != null ? refreshToken.getIpAddress() : "Unknown")), "If this was you, you can safely ignore this email. If you didn't log in from this device, please change your password immediately and contact your administrator.", "#4299E1");
        try {
            this.emailService.sendEmail(List.of(user.getEmail()), subject, htmlBody, (File)null);
            log.info("New device notification sent successfully to: {}", (Object)user.getEmail());
        }
        catch (Exception e) {
            log.error("Failed to send new device notification to: {}", (Object)user.getEmail(), (Object)e);
        }
    }

    public void notifySuspiciousActivity(PortalUser user, String reason, String ipAddress) {
        if (user == null || !StringUtils.hasText((String)user.getEmail())) {
            log.warn("Skipping suspicious activity notification - user email is null/empty for user id {}", (Object)(user != null ? user.getId() : null));
            return;
        }
        log.warn("Sending suspicious activity notification to: {} - Reason: {}", (Object)user.getEmail(), (Object)reason);
        String subject = "\u26a0\ufe0f Suspicious Activity Alert - CBM Portal";
        String htmlBody = this.buildEmailTemplate("Suspicious Activity Detected", user.getUserFirst(), "We detected suspicious activity on your CBM Portal account.", List.of("Reason: " + reason, "IP Address: " + ipAddress, "Time: " + Instant.now().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER)), "For your security, we recommend changing your password immediately. If you need assistance, please contact your administrator.", "#E53E3E");
        try {
            this.emailService.sendEmail(List.of(user.getEmail()), subject, htmlBody, (File)null);
            log.info("Suspicious activity notification sent to: {}", (Object)user.getEmail());
        }
        catch (Exception e) {
            log.error("Failed to send suspicious activity notification to: {}", (Object)user.getEmail(), (Object)e);
        }
    }

    public void notifySessionRevoked(PortalUser user, String deviceInfo, String revokedBy) {
        if (user == null || !StringUtils.hasText((String)user.getEmail())) {
            log.warn("Skipping session revoked notification - user email is null/empty for user id {}", (Object)(user != null ? user.getId() : null));
            return;
        }
        log.info("Sending session revoked notification to: {}", (Object)user.getEmail());
        String browser = this.deviceInfoService.getBrowser(deviceInfo);
        String os = this.deviceInfoService.getOperatingSystem(deviceInfo);
        String deviceDescription = browser + " on " + os;
        String subject = "Session Logged Out - CBM Portal";
        String htmlBody = this.buildEmailTemplate("Session Logged Out", user.getUserFirst(), "A session on your CBM Portal account was logged out.", List.of("Device: " + deviceDescription, "Logged out by: " + revokedBy, "Time: " + Instant.now().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER)), "If you didn't log out this device, please change your password immediately and contact your administrator.", "#F59E0B");
        try {
            this.emailService.sendEmail(List.of(user.getEmail()), subject, htmlBody, (File)null);
            log.info("Session revoked notification sent to: {}", (Object)user.getEmail());
        }
        catch (Exception e) {
            log.error("Failed to send session revoked notification to: {}", (Object)user.getEmail(), (Object)e);
        }
    }

    public void notifyPasswordChange(PortalUser user) {
        if (user == null || !StringUtils.hasText((String)user.getEmail())) {
            log.warn("Skipping password change notification - user email is null/empty for user id {}", (Object)(user != null ? user.getId() : null));
            return;
        }
        log.info("Sending password change notification to: {}", (Object)user.getEmail());
        String subject = "Password Changed - CBM Portal";
        String htmlBody = this.buildEmailTemplate("Password Changed", user.getUserFirst(), "Your CBM Portal password was successfully changed.", List.of("Time: " + Instant.now().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER)), "All your active sessions have been logged out for security. Please log in with your new password. If you didn't change your password, contact your administrator immediately.", "#10B981");
        try {
            this.emailService.sendEmail(List.of(user.getEmail()), subject, htmlBody, (File)null);
            log.info("Password change notification sent to: {}", (Object)user.getEmail());
        }
        catch (Exception e) {
            log.error("Failed to send password change notification to: {}", (Object)user.getEmail(), (Object)e);
        }
    }

    public void notifyFailedLoginAttempts(String username, int attemptCount, String ipAddress) {
        log.warn("Detected {} failed login attempts for user: {} from IP: {}", new Object[]{attemptCount, username, ipAddress});
        log.info("Would send failed login notification to user: {}", (Object)username);
    }

    private String buildEmailTemplate(String title, String userName, String message, List<String> details, String action, String accentColor) {
        StringBuilder detailsHtml = new StringBuilder();
        for (String detail : details) {
            detailsHtml.append("<li style='margin: 8px 0; color: #4a5568;'>").append(detail).append("</li>");
        }
        return String.format("<!DOCTYPE html>\n<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n</head>\n<body style=\"margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif; background-color: #f7fafc;\">\n    <table width=\"100%%\" cellpadding=\"0\" cellspacing=\"0\" style=\"background-color: #f7fafc; padding: 40px 0;\">\n        <tr>\n            <td align=\"center\">\n                <table width=\"600\" cellpadding=\"0\" cellspacing=\"0\" style=\"background-color: #ffffff; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);\">\n                    <!-- Header -->\n                    <tr>\n                        <td style=\"background-color: %s; padding: 30px; text-align: center; border-radius: 8px 8px 0 0;\">\n                            <h1 style=\"margin: 0; color: #ffffff; font-size: 24px; font-weight: 600;\">%s</h1>\n                        </td>\n                    </tr>\n\n                    <!-- Body -->\n                    <tr>\n                        <td style=\"padding: 40px;\">\n                            <p style=\"margin: 0 0 20px 0; color: #2d3748; font-size: 16px;\">Hi %s,</p>\n\n                            <p style=\"margin: 0 0 20px 0; color: #2d3748; font-size: 16px;\">%s</p>\n\n                            <div style=\"background-color: #f7fafc; border-left: 4px solid %s; padding: 20px; margin: 20px 0; border-radius: 4px;\">\n                                <ul style=\"margin: 0; padding-left: 20px;\">\n                                    %s\n                                </ul>\n                            </div>\n\n                            <p style=\"margin: 20px 0 0 0; color: #4a5568; font-size: 14px; line-height: 1.6;\">%s</p>\n                        </td>\n                    </tr>\n\n                    <!-- Footer -->\n                    <tr>\n                        <td style=\"background-color: #f7fafc; padding: 30px; text-align: center; border-radius: 0 0 8px 8px; border-top: 1px solid #e2e8f0;\">\n                            <p style=\"margin: 0; color: #718096; font-size: 14px;\">\n                                This is an automated security notification from CBM Portal.\n                            </p>\n                            <p style=\"margin: 10px 0 0 0; color: #a0aec0; font-size: 12px;\">\n                                \u00a9 2025 CBM Portal. All rights reserved.\n                            </p>\n                        </td>\n                    </tr>\n                </table>\n            </td>\n        </tr>\n    </table>\n</body>\n</html>\n", accentColor, title, userName, message, accentColor, detailsHtml.toString(), action);
    }
}

