/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.TerminationType;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Termination {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="termination_id_seq")
    @SequenceGenerator(name="termination_id_seq", sequenceName="termination_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    private String quitReason;
    @JsonProperty
    private LocalDate lastDayWorked;
    @JsonProperty
    private Boolean eligibleRehire = false;
    @JsonProperty
    private Boolean twoWeeksGiven = false;
    @JsonProperty
    private Boolean warningsGiven = false;
    @JsonProperty
    private TerminationType termType;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser;
    @JsonProperty
    private LocalDateTime submittedDate = null;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public Termination() {
    }

    public Termination(String quitReason, LocalDate lastDayWorked, Boolean eligibleRehire, Boolean twoWeeksGiven, Boolean warningsGiven, TerminationType termType, Employee employee, PortalUser portalUser, ApiError apiError) {
        this.quitReason = quitReason;
        this.lastDayWorked = lastDayWorked;
        this.eligibleRehire = eligibleRehire;
        this.twoWeeksGiven = twoWeeksGiven;
        this.warningsGiven = warningsGiven;
        this.termType = termType;
        this.employee = employee;
        this.portalUser = portalUser;
        this.apiError = apiError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Termination that = (Termination)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.quitReason, that.quitReason) && Objects.equals(this.lastDayWorked, that.lastDayWorked) && Objects.equals(this.eligibleRehire, that.eligibleRehire) && Objects.equals(this.twoWeeksGiven, that.twoWeeksGiven) && Objects.equals(this.warningsGiven, that.warningsGiven) && this.termType == that.termType && Objects.equals(this.employee, that.employee) && Objects.equals(this.portalUser, that.portalUser) && Objects.equals(this.apiError, that.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", Termination.class.getSimpleName() + "[", "]").add("id=" + this.id).add("quitReason='" + this.quitReason + "'").add("lastDayWorked=" + String.valueOf(this.lastDayWorked)).add("eligibleRehire=" + this.eligibleRehire).add("twoWeeksGiven=" + this.twoWeeksGiven).add("warningsGiven=" + this.warningsGiven).add("termType=" + String.valueOf(this.termType)).add("employee=" + String.valueOf(this.employee)).add("portalUser=" + String.valueOf(this.portalUser)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.quitReason, this.lastDayWorked, this.eligibleRehire, this.twoWeeksGiven, this.warningsGiven, this.termType, this.employee, this.portalUser, this.apiError);
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setQuitReason(String quitReason) {
        this.quitReason = quitReason;
    }

    @JsonProperty
    @Generated
    public void setLastDayWorked(LocalDate lastDayWorked) {
        this.lastDayWorked = lastDayWorked;
    }

    @JsonProperty
    @Generated
    public void setEligibleRehire(Boolean eligibleRehire) {
        this.eligibleRehire = eligibleRehire;
    }

    @JsonProperty
    @Generated
    public void setTwoWeeksGiven(Boolean twoWeeksGiven) {
        this.twoWeeksGiven = twoWeeksGiven;
    }

    @JsonProperty
    @Generated
    public void setWarningsGiven(Boolean warningsGiven) {
        this.warningsGiven = warningsGiven;
    }

    @JsonProperty
    @Generated
    public void setTermType(TerminationType termType) {
        this.termType = termType;
    }

    @JsonProperty
    @Generated
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @Generated
    public void setSubmittedDate(LocalDateTime submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getQuitReason() {
        return this.quitReason;
    }

    @Generated
    public LocalDate getLastDayWorked() {
        return this.lastDayWorked;
    }

    @Generated
    public Boolean getEligibleRehire() {
        return this.eligibleRehire;
    }

    @Generated
    public Boolean getTwoWeeksGiven() {
        return this.twoWeeksGiven;
    }

    @Generated
    public Boolean getWarningsGiven() {
        return this.warningsGiven;
    }

    @Generated
    public TerminationType getTermType() {
        return this.termType;
    }

    @Generated
    public Employee getEmployee() {
        return this.employee;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public LocalDateTime getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

