/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.BackPay;
import com.cbmportal.portal.domains.Bonus;
import com.cbmportal.portal.domains.Mileage;
import com.cbmportal.portal.domains.Pto;
import com.cbmportal.portal.domains.TimeAdjustment;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.services.BackPayService;
import com.cbmportal.portal.services.BonusService;
import com.cbmportal.portal.services.MileageService;
import com.cbmportal.portal.services.PtoService;
import com.cbmportal.portal.services.TimeAdjustmentService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/payroll"})
public class PayrollSubmissionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PayrollSubmissionController.class);
    private final BackPayService backPayService;
    private final BonusService bonusService;
    private final MileageService mileageService;
    private final TimeAdjustmentService timeAdjustmentService;
    private final PtoService ptoService;

    public PayrollSubmissionController(BackPayService backPayService, BonusService bonusService, MileageService mileageService, TimeAdjustmentService timeAdjustmentService, PtoService ptoService) {
        this.backPayService = backPayService;
        this.bonusService = bonusService;
        this.mileageService = mileageService;
        this.timeAdjustmentService = timeAdjustmentService;
        this.ptoService = ptoService;
    }

    @PostMapping(value={"/backPaySubmit"})
    public ResponseEntity<FormSubmissionResponse> submitBackPay(@RequestBody @Valid BackPay backPay) {
        log.info("Back pay submission received for employee: {}", backPay.getEmployee() != null ? backPay.getEmployee().getEmployeeNumber() : "unknown");
        FormSubmissionResponse response = this.backPayService.processBackPay(backPay);
        log.info("Back pay processed successfully for employee: {}", (Object)backPay.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/bonusSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitBonus(@RequestBody @Valid Bonus bonus) {
        log.info("Bonus submission received for employee: {}", bonus.getEmployee() != null ? bonus.getEmployee().getEmployeeNumber() : "unknown");
        FormSubmissionResponse response = this.bonusService.processBonus(bonus);
        log.info("Bonus processed successfully for employee: {}", (Object)bonus.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/mileageSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitMileage(@RequestBody @Valid Mileage mileage) {
        log.info("Mileage submission received for employee: {}", mileage.getEmployee() != null ? mileage.getEmployee().getEmployeeNumber() : "unknown");
        FormSubmissionResponse response = this.mileageService.processMileage(mileage);
        log.info("Mileage processed successfully for employee: {}", (Object)mileage.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/ptoSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitPto(@RequestBody @Valid Pto pto) {
        log.info("PTO submission received for employee: {}", pto.getEmployee() != null ? pto.getEmployee().getEmployeeNumber() : "unknown");
        FormSubmissionResponse response = this.ptoService.processPto(pto);
        log.info("PTO processed successfully for employee: {}", (Object)pto.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/timeAdjustmentSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitTimeAdjustment(@RequestBody @Valid TimeAdjustment timeAdjustment) {
        log.info("Time adjustment submission received for employee: {}", timeAdjustment.getEmployee() != null ? timeAdjustment.getEmployee().getEmployeeNumber() : "unknown");
        FormSubmissionResponse response = this.timeAdjustmentService.processTimeAdjustment(timeAdjustment);
        log.info("Time adjustment processed successfully for employee: {}", (Object)timeAdjustment.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }
}

