/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.NonMnMileage;
import com.cbmportal.portal.domains.PerDiem;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.domains.VO.HotelRequestDTO;
import com.cbmportal.portal.domains.VO.NonMnMileageRequestDTO;
import com.cbmportal.portal.domains.VO.PerDiemRequestDTO;
import com.cbmportal.portal.domains.VO.WorkTicketRequestDTO;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.services.HotelService;
import com.cbmportal.portal.services.NonMnMileageService;
import com.cbmportal.portal.services.PerDiemService;
import com.cbmportal.portal.services.WorkTicketService;
import com.cbmportal.portal.services.util.FormDtoMapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/finance/"})
public class FinanceSubmissionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinanceSubmissionController.class);
    private final WorkTicketService workTicketService;
    private final HotelService hotelService;
    private final PerDiemService perDiemService;
    private final NonMnMileageService nonMnMileageService;
    private final FormDtoMapper formDtoMapper;

    public FinanceSubmissionController(WorkTicketService workTicketService, HotelService hotelService, PerDiemService perDiemService, NonMnMileageService nonMnMileageService, FormDtoMapper formDtoMapper) {
        this.workTicketService = workTicketService;
        this.hotelService = hotelService;
        this.perDiemService = perDiemService;
        this.nonMnMileageService = nonMnMileageService;
        this.formDtoMapper = formDtoMapper;
    }

    @PostMapping(value={"workTicketSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitWorkTicket(@RequestBody WorkTicketRequestDTO dto, HttpServletResponse response) {
        log.info("Work ticket submission received");
        if (dto.getCurrentLocation() == null || dto.getProjectLocation() == null) {
            return this.badRequest("WorkTicket Form", "submitWorkTicket", "Current location and project location are required");
        }
        try {
            WorkTicket wt = this.formDtoMapper.toWorkTicket(dto);
            log.debug("Mapped WorkTicket from DTO: {}", (Object)wt);
            FormSubmissionResponse formResponse = this.workTicketService.processWorkTicket(wt, response);
            return ResponseEntity.ok((Object)formResponse);
        }
        catch (IOException | IllegalArgumentException iae) {
            return this.badRequest("WorkTicket Form", "submitWorkTicket", "Invalid typeOfWork: " + dto.getTypeOfWork());
        }
    }

    @PostMapping(value={"hotelSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitHotel(@RequestBody HotelRequestDTO dto, HttpServletResponse response) {
        log.info("Hotel submission received");
        if (dto.getStore() == null) {
            return this.badRequest("Hotel Form", "submitHotel", "Store is required");
        }
        try {
            Hotel hotel = this.formDtoMapper.toHotel(dto);
            FormSubmissionResponse formResponse = this.hotelService.requestHotel(hotel, response);
            return ResponseEntity.ok((Object)formResponse);
        }
        catch (IOException | IllegalArgumentException iae) {
            return this.badRequest("Hotel Form", "submitHotel", "Invalid hotelReason: " + dto.getHotelReason());
        }
    }

    @PostMapping(value={"perDiemSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitPerDiem(@RequestBody PerDiemRequestDTO dto, HttpServletResponse response) throws IOException {
        log.info("Per diem submission received");
        if (dto.getMileageDates() == null || dto.getMileageDates().isEmpty()) {
            return this.badRequest("PerDiem Form", "submitPerDiem", "mileageDates are required");
        }
        PerDiem perDiem = this.formDtoMapper.toPerDiem(dto);
        FormSubmissionResponse formResponse = this.perDiemService.processPerDiem(perDiem, response);
        return ResponseEntity.ok((Object)formResponse);
    }

    @PostMapping(value={"/nonMnMileageSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitNonMnMileage(@RequestBody NonMnMileageRequestDTO dto, HttpServletResponse response) throws IOException {
        log.info("Non-MN mileage submission received");
        if (dto.getEmployee() == null) {
            return this.badRequest("Non MN Mileage Form", "nonMnMileageSubmit", "employee is required");
        }
        if (dto.getMileageDates() == null || dto.getMileageDates().isEmpty()) {
            return this.badRequest("Non MN Mileage Form", "nonMnMileageSubmit", "mileageDates are required");
        }
        NonMnMileage mileage = this.formDtoMapper.toNonMnMileage(dto);
        FormSubmissionResponse formResponse = this.nonMnMileageService.processMileage(mileage, response);
        return ResponseEntity.ok((Object)formResponse);
    }

    private ResponseEntity<FormSubmissionResponse> badRequest(String formName, String operation, String message) {
        return ResponseEntity.badRequest().body((Object)new FormSubmissionResponse(formName, false, new ApiError(operation, message)));
    }
}

