/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.services.PdfBuilderService;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.IOException;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PdfBuilderServiceServiceImpl
implements PdfBuilderService {
    final Logger log = LoggerFactory.getLogger(PdfBuilderServiceServiceImpl.class);

    public void generatePdf(String pdfSaveLocation, String pdfFileName, Document doc) throws IOException {
        this.validateInputs(pdfSaveLocation, pdfFileName, doc);
        String fullPath = pdfSaveLocation + pdfFileName;
        this.log.info("Generating PDF at: {}", (Object)fullPath);
        try (PdfWriter writer = new PdfWriter(fullPath);){
            this.log.debug("Converting HTML to PDF");
            HtmlConverter.convertToPdf((String)doc.toString(), (PdfWriter)writer);
            this.log.info("PDF generated successfully: {}", (Object)pdfFileName);
        }
        catch (IOException e) {
            this.log.error("Failed to generate PDF: {} at location: {}", new Object[]{pdfFileName, fullPath, e});
            throw new FormProcessingException("Failed to generate PDF: " + pdfFileName, (Throwable)e);
        }
    }

    private void validateInputs(String location, String fileName, Document doc) {
        if (location == null || location.trim().isEmpty()) {
            throw new IllegalArgumentException("PDF save location cannot be null or empty");
        }
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("PDF file name cannot be null or empty");
        }
        if (doc == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
    }
}

